/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.util.AssertionUtil;

public class BasicCtType
extends AbstractCtType {
    private final TypeMirror boxedType;
    private final TypeMirror wrapperType;

    BasicCtType(Context ctx, TypeMirror type, TypeMirror wrapperType) {
        super(ctx, type);
        AssertionUtil.assertNotNull(wrapperType);
        this.boxedType = ctx.getMoreTypes().boxIfPrimitive(type);
        this.wrapperType = wrapperType;
    }

    public TypeMirror getBoxedType() {
        return this.boxedType;
    }

    public Code getWrapperSupplierCode() {
        return new Code(p -> {
            if (this.isEnum()) {
                p.print("() -> new %1$s(%2$s.class)", this.wrapperType, this.getQualifiedName());
            } else {
                p.print("%1$s::new", this.wrapperType);
            }
        });
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitBasicCtType(this, p);
    }
}

