/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public class CollectorCtType
extends AbstractCtType {
    private final CtType targetCtType;
    private final CtType returnCtType;

    CollectorCtType(Context ctx, TypeMirror type, CtType targetCtType, CtType returnCtType) {
        super(ctx, type);
        AssertionUtil.assertNotNull((Object)targetCtType, (Object)returnCtType);
        this.targetCtType = targetCtType;
        this.returnCtType = returnCtType;
    }

    public CtType getTargetCtType() {
        return this.targetCtType;
    }

    public CtType getReturnCtType() {
        return this.returnCtType;
    }

    public boolean isRaw() {
        return this.targetCtType.isNone() || this.returnCtType.isNone();
    }

    public boolean hasWildcard() {
        return this.targetCtType.isWildcard() || this.returnCtType.isWildcard();
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitCollectorCtType(this, p);
    }
}

