/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.seasar.doma.Domain;
import org.seasar.doma.Embeddable;
import org.seasar.doma.Entity;
import org.seasar.doma.experimental.DataType;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.DomainConvertersAnnot;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.ArrayCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.BatchResultCtType;
import org.seasar.doma.internal.apt.cttype.BiFunctionCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.ConfigCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.NoneCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.PreparedSqlCtType;
import org.seasar.doma.internal.apt.cttype.ReferenceCtType;
import org.seasar.doma.internal.apt.cttype.ResultCtType;
import org.seasar.doma.internal.apt.cttype.SelectOptionsCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.util.ElementKindUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.BatchResult;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.Reference;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.domain.DomainConverter;
import org.seasar.doma.message.Message;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LocalDateTimeWrapper;
import org.seasar.doma.wrapper.LocalDateWrapper;
import org.seasar.doma.wrapper.LocalTimeWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ObjectWrapper;
import org.seasar.doma.wrapper.PrimitiveBooleanWrapper;
import org.seasar.doma.wrapper.PrimitiveByteWrapper;
import org.seasar.doma.wrapper.PrimitiveDoubleWrapper;
import org.seasar.doma.wrapper.PrimitiveFloatWrapper;
import org.seasar.doma.wrapper.PrimitiveIntWrapper;
import org.seasar.doma.wrapper.PrimitiveLongWrapper;
import org.seasar.doma.wrapper.PrimitiveShortWrapper;
import org.seasar.doma.wrapper.SQLXMLWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;

public class CtTypes {
    private final Context ctx;

    public CtTypes(Context ctx) {
        this.ctx = ctx;
    }

    private AnyCtType newAnyCtType(TypeMirror type) {
        return new AnyCtType(this.ctx, type);
    }

    private BatchResultCtType newBatchResultCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, BatchResult.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType elementCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new BatchResultCtType(this.ctx, type, elementCtType);
    }

    public BasicCtType newBasicCtType(TypeMirror type) {
        AssertionUtil.assertNotNull(type);
        TypeMirror wrapperType = this.getWrapperType(type);
        if (wrapperType == null) {
            return null;
        }
        return new BasicCtType(this.ctx, type, wrapperType);
    }

    private TypeMirror getWrapperType(TypeMirror type) {
        Class wrapperClass = (Class)type.accept(new WrapperClassResolver(), null);
        if (wrapperClass == null) {
            return null;
        }
        TypeElement wrapperTypeElement = this.ctx.getMoreElements().getTypeElement(wrapperClass);
        if (wrapperTypeElement == null) {
            return null;
        }
        if (wrapperClass == EnumWrapper.class) {
            return this.ctx.getMoreTypes().getDeclaredType(wrapperTypeElement, type);
        }
        return wrapperTypeElement.asType();
    }

    private BiFunctionCtType newBiFunctionCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, BiFunction.class);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType firstArgCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        NoneCtType secondArgCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        NoneCtType resultCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new BiFunctionCtType(this.ctx, type, firstArgCtType, secondArgCtType, resultCtType);
    }

    private CollectorCtType newCollectorCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, Collector.class);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType targetCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        NoneCtType secondCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        NoneCtType returnCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new CollectorCtType(this.ctx, type, targetCtType, returnCtType);
    }

    private ConfigCtType newConfigCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Config.class)) {
            return null;
        }
        return new ConfigCtType(this.ctx, type);
    }

    public DomainCtType newDomainCtType(TypeMirror type) {
        ClassName descClassName;
        AssertionUtil.assertNotNull(type);
        if (type.getKind() == TypeKind.ARRAY) {
            DomainInfo info = this.getExternalDomainInfo(type);
            if (info == null) {
                return null;
            }
            BasicCtType basicCtType = this.newBasicCtType(info.valueType);
            if (basicCtType == null) {
                return null;
            }
            Name name = this.ctx.getNames().createExternalDomainName(type);
            ClassName descClassName2 = ClassNames.newExternalDomainDescClassName(name);
            return new DomainCtType(this.ctx, type, basicCtType, Collections.emptyList(), descClassName2);
        }
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        DomainInfo info = this.getDomainInfo(typeElement);
        if (info == null) {
            return null;
        }
        BasicCtType basicCtType = this.newBasicCtType(info.valueType);
        if (basicCtType == null) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        List<CtType> typeArgCtTypes = typeElement.getTypeParameters().stream().map(__ -> typeArgs.hasNext() ? this.newCtType((TypeMirror)typeArgs.next()) : this.newNoneCtType()).collect(Collectors.toList());
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        if (info.external) {
            Name name = this.ctx.getNames().createExternalDomainName(type);
            descClassName = ClassNames.newExternalDomainDescClassName(name);
        } else {
            descClassName = ClassNames.newDomainDescClassName(binaryName);
        }
        return new DomainCtType(this.ctx, type, basicCtType, typeArgCtTypes, descClassName);
    }

    private DomainInfo getDomainInfo(TypeElement typeElement) {
        Domain domain = typeElement.getAnnotation(Domain.class);
        if (domain != null) {
            return this.getDomainInfo(domain);
        }
        DataType dataType = typeElement.getAnnotation(DataType.class);
        if (dataType != null) {
            return this.getDomainInfo(typeElement, dataType);
        }
        return this.getExternalDomainInfo(typeElement.asType());
    }

    private DomainInfo getDomainInfo(Domain domain) {
        try {
            domain.valueType();
        }
        catch (MirroredTypeException e) {
            return new DomainInfo(e.getTypeMirror(), false);
        }
        throw new AptIllegalStateException("unreachable.");
    }

    private DomainInfo getDomainInfo(TypeElement typeElement, DataType dataType) {
        VariableElement param = this.ctx.getMoreElements().getSingleParameterOfRecordConstructor(typeElement);
        if (param == null) {
            throw new AptIllegalStateException(typeElement.getQualifiedName().toString());
        }
        return new DomainInfo(param.asType(), false);
    }

    private DomainInfo getExternalDomainInfo(TypeMirror domainType) {
        String csv = this.ctx.getOptions().getDomainConverters();
        if (csv != null) {
            for (String value : csv.split(",")) {
                String className = value.trim();
                if (className.isEmpty()) continue;
                TypeElement convertersProviderElement = this.ctx.getMoreElements().getTypeElementFromBinaryName(className);
                if (convertersProviderElement == null) {
                    throw new AptIllegalOptionException(Message.DOMA4200.getMessage(className));
                }
                DomainConvertersAnnot convertersMirror = this.ctx.getAnnotations().newDomainConvertersAnnot(convertersProviderElement);
                if (convertersMirror == null) {
                    throw new AptIllegalOptionException(Message.DOMA4201.getMessage(className));
                }
                for (TypeMirror converterType : convertersMirror.getValueValue()) {
                    TypeMirror[] argTypes;
                    if ((converterType = this.reloadTypeMirror(converterType)) == null || (argTypes = this.getConverterArgTypes(converterType)) == null || !this.ctx.getMoreTypes().isSameTypeWithErasure(domainType, argTypes[0])) continue;
                    TypeMirror valueType = argTypes[1];
                    return new DomainInfo(valueType, true);
                }
            }
        }
        return null;
    }

    private TypeMirror reloadTypeMirror(TypeMirror typeMirror) {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(typeMirror);
        if (typeElement == null) {
            return null;
        }
        typeElement = this.ctx.getMoreElements().getTypeElement(typeElement.getQualifiedName());
        if (typeElement == null) {
            return null;
        }
        return typeElement.asType();
    }

    private TypeMirror[] getConverterArgTypes(TypeMirror typeMirror) {
        for (TypeMirror typeMirror2 : this.ctx.getMoreTypes().directSupertypes(typeMirror)) {
            if (!this.ctx.getMoreTypes().isAssignableWithErasure(typeMirror2, DomainConverter.class)) continue;
            if (this.ctx.getMoreTypes().isSameTypeWithErasure(typeMirror2, DomainConverter.class)) {
                DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(typeMirror2);
                AssertionUtil.assertNotNull(declaredType);
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                AssertionUtil.assertEquals(2, args.size());
                return new TypeMirror[]{args.get(0), args.get(1)};
            }
            TypeMirror[] argTypes = this.getConverterArgTypes(typeMirror2);
            if (argTypes == null) continue;
            return argTypes;
        }
        return null;
    }

    private EmbeddableCtType newEmbeddableCtType(TypeMirror type) {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        Embeddable embeddable = typeElement.getAnnotation(Embeddable.class);
        if (embeddable == null) {
            return null;
        }
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        ClassName descClassName = ClassNames.newEmbeddableDescClassName(binaryName);
        return new EmbeddableCtType(this.ctx, type, descClassName);
    }

    private EntityCtType newEntityCtType(TypeMirror type) {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        Entity entity = typeElement.getAnnotation(Entity.class);
        if (entity == null) {
            return null;
        }
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        ClassName descClassName = ClassNames.newEntityDescClassName(binaryName);
        boolean immutable = ElementKindUtil.isRecord(typeElement.getKind()) || entity.immutable();
        return new EntityCtType(this.ctx, type, immutable, descClassName);
    }

    private FunctionCtType newFunctionCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, Function.class);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType targetCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        NoneCtType returnCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new FunctionCtType(this.ctx, type, targetCtType, returnCtType);
    }

    public IterableCtType newIterableCtType(TypeMirror type) {
        AssertionUtil.assertNotNull(type);
        DeclaredType declaredType = this.getSuperDeclaredType(type, Iterable.class);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType elementCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new IterableCtType(this.ctx, type, elementCtType);
    }

    public ArrayCtType newArrayCtType(TypeMirror type) {
        AssertionUtil.assertNotNull(type);
        if (type.getKind() != TypeKind.ARRAY) {
            return null;
        }
        TypeMirror componentType = ((ArrayType)type).getComponentType();
        if (componentType.getKind() == TypeKind.BYTE) {
            return null;
        }
        CtType elementCtType = this.newCtType(componentType);
        return new ArrayCtType(this.ctx, type, elementCtType);
    }

    private MapCtType newMapCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Map.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs.size() != 2) {
            return null;
        }
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(typeArgs.get(0), String.class)) {
            return null;
        }
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(typeArgs.get(1), Object.class)) {
            return null;
        }
        return new MapCtType(this.ctx, type);
    }

    private NoneCtType newNoneCtType() {
        NoType type = this.ctx.getMoreTypes().getNoType(TypeKind.NONE);
        return new NoneCtType(this.ctx, type);
    }

    private OptionalCtType newOptionalCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Optional.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType elementCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new OptionalCtType(this.ctx, type, elementCtType);
    }

    private OptionalDoubleCtType newOptionalDoubleCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, OptionalDouble.class)) {
            return null;
        }
        PrimitiveType primitiveType = this.ctx.getMoreTypes().getPrimitiveType(TypeKind.DOUBLE);
        BasicCtType elementCtType = this.newBasicCtType(primitiveType);
        return new OptionalDoubleCtType(this.ctx, type, elementCtType);
    }

    private OptionalIntCtType newOptionalIntCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, OptionalInt.class)) {
            return null;
        }
        PrimitiveType primitiveType = this.ctx.getMoreTypes().getPrimitiveType(TypeKind.INT);
        BasicCtType elementCtType = this.newBasicCtType(primitiveType);
        return new OptionalIntCtType(this.ctx, type, elementCtType);
    }

    private OptionalLongCtType newOptionalLongCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, OptionalLong.class)) {
            return null;
        }
        PrimitiveType primitiveType = this.ctx.getMoreTypes().getPrimitiveType(TypeKind.LONG);
        BasicCtType elementCtType = this.newBasicCtType(primitiveType);
        return new OptionalLongCtType(this.ctx, type, elementCtType);
    }

    private PreparedSqlCtType newPreparedSqlCtType(TypeMirror type) {
        AssertionUtil.assertNotNull(type);
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, PreparedSql.class)) {
            return null;
        }
        return new PreparedSqlCtType(this.ctx, type);
    }

    private ReferenceCtType newReferenceCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, Reference.class);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType referentCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new ReferenceCtType(this.ctx, type, referentCtType);
    }

    private ResultCtType newResultCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Result.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType elementCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new ResultCtType(this.ctx, type, elementCtType);
    }

    private SelectOptionsCtType newSelectOptionsCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isAssignableWithErasure(type, SelectOptions.class)) {
            return null;
        }
        return new SelectOptionsCtType(this.ctx, type);
    }

    private StreamCtType newStreamCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Stream.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        Iterator<? extends TypeMirror> typeArgs = declaredType.getTypeArguments().iterator();
        NoneCtType elementCtType = typeArgs.hasNext() ? this.newCtType(typeArgs.next()) : this.newNoneCtType();
        return new StreamCtType(this.ctx, type, elementCtType);
    }

    public CtType newCtType(TypeMirror type, CtTypeVisitor<Void, Void, AptException> validator) {
        AssertionUtil.assertNotNull((Object)type, validator);
        return this.newCtTypeInternal(type, validator);
    }

    public CtType newCtType(TypeMirror type) {
        return this.newCtTypeInternal(type, new SimpleCtTypeVisitor<Void, Void, AptException>());
    }

    private CtType newCtTypeInternal(TypeMirror type, CtTypeVisitor<Void, Void, AptException> validator) {
        List<Function> functions = Arrays.asList(this::newIterableCtType, this::newStreamCtType, this::newEntityCtType, this::newOptionalCtType, this::newOptionalIntCtType, this::newOptionalLongCtType, this::newOptionalDoubleCtType, this::newDomainCtType, this::newEmbeddableCtType, this::newBasicCtType, this::newMapCtType, this::newSelectOptionsCtType, this::newFunctionCtType, this::newCollectorCtType, this::newReferenceCtType, this::newBiFunctionCtType, this::newPreparedSqlCtType, this::newConfigCtType, this::newResultCtType, this::newBatchResultCtType, this::newArrayCtType);
        CtType ctType = functions.stream().map(f -> (CtType)f.apply(type)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.newAnyCtType(type));
        ctType.accept(validator, null);
        return ctType;
    }

    private DeclaredType getSuperDeclaredType(TypeMirror type, Class<?> superclass) {
        if (this.ctx.getMoreTypes().isSameTypeWithErasure(type, superclass)) {
            return this.ctx.getMoreTypes().toDeclaredType(type);
        }
        for (TypeMirror typeMirror : this.ctx.getMoreTypes().directSupertypes(type)) {
            if (this.ctx.getMoreTypes().isSameTypeWithErasure(typeMirror, superclass)) {
                return this.ctx.getMoreTypes().toDeclaredType(typeMirror);
            }
            DeclaredType result = this.getSuperDeclaredType(typeMirror, superclass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private class WrapperClassResolver
    extends SimpleTypeVisitor8<Class<?>, Void> {
        private WrapperClassResolver() {
        }

        @Override
        public Class<?> visitArray(ArrayType t, Void p) {
            if (t.getComponentType().getKind() == TypeKind.BYTE) {
                return BytesWrapper.class;
            }
            return null;
        }

        @Override
        public Class<?> visitDeclared(DeclaredType t, Void p) {
            TypeElement typeElement = CtTypes.this.ctx.getMoreTypes().toTypeElement(t);
            if (typeElement == null) {
                return null;
            }
            if (typeElement.getKind() == ElementKind.ENUM) {
                return EnumWrapper.class;
            }
            String name = typeElement.getQualifiedName().toString();
            if (String.class.getName().equals(name)) {
                return StringWrapper.class;
            }
            if (Boolean.class.getName().equals(name)) {
                return BooleanWrapper.class;
            }
            if (Byte.class.getName().equals(name)) {
                return ByteWrapper.class;
            }
            if (Short.class.getName().equals(name)) {
                return ShortWrapper.class;
            }
            if (Integer.class.getName().equals(name)) {
                return IntegerWrapper.class;
            }
            if (Long.class.getName().equals(name)) {
                return LongWrapper.class;
            }
            if (Float.class.getName().equals(name)) {
                return FloatWrapper.class;
            }
            if (Double.class.getName().equals(name)) {
                return DoubleWrapper.class;
            }
            if (Object.class.getName().equals(name)) {
                return ObjectWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, BigDecimal.class)) {
                return BigDecimalWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, BigInteger.class)) {
                return BigIntegerWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Time.class)) {
                return TimeWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Timestamp.class)) {
                return TimestampWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, java.sql.Date.class)) {
                return DateWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Date.class)) {
                return UtilDateWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, LocalTime.class)) {
                return LocalTimeWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, LocalDateTime.class)) {
                return LocalDateTimeWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, LocalDate.class)) {
                return LocalDateWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Array.class)) {
                return ArrayWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Blob.class)) {
                return BlobWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, NClob.class)) {
                return NClobWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Clob.class)) {
                return ClobWrapper.class;
            }
            if (CtTypes.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, SQLXML.class)) {
                return SQLXMLWrapper.class;
            }
            return null;
        }

        @Override
        public Class<?> visitPrimitive(PrimitiveType t, Void p) {
            switch (t.getKind()) {
                case BOOLEAN: {
                    return PrimitiveBooleanWrapper.class;
                }
                case BYTE: {
                    return PrimitiveByteWrapper.class;
                }
                case SHORT: {
                    return PrimitiveShortWrapper.class;
                }
                case INT: {
                    return PrimitiveIntWrapper.class;
                }
                case LONG: {
                    return PrimitiveLongWrapper.class;
                }
                case FLOAT: {
                    return PrimitiveFloatWrapper.class;
                }
                case DOUBLE: {
                    return PrimitiveDoubleWrapper.class;
                }
                case CHAR: {
                    return null;
                }
            }
            return (Class)AssertionUtil.assertUnreachable();
        }
    }

    private static class DomainInfo {
        private final TypeMirror valueType;
        private final boolean external;

        DomainInfo(TypeMirror valueType, boolean external) {
            AssertionUtil.assertNotNull(valueType);
            this.valueType = valueType;
            this.external = external;
        }
    }
}

