/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public class IterableCtType
extends AbstractCtType {
    private final CtType elementCtType;

    IterableCtType(Context ctx, TypeMirror type, CtType elementCtType) {
        super(ctx, type);
        AssertionUtil.assertNotNull(elementCtType);
        this.elementCtType = elementCtType;
    }

    public CtType getElementCtType() {
        return this.elementCtType;
    }

    public boolean isRaw() {
        return this.elementCtType.isNone();
    }

    public boolean hasWildcard() {
        return this.elementCtType.isWildcard();
    }

    public boolean isList() {
        return this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, List.class);
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitIterableCtType(this, p);
    }
}

