/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.domain;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.DomainAnnot;
import org.seasar.doma.internal.apt.annot.ValueAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.def.TypeParametersDef;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.domain.DomainMeta;
import org.seasar.doma.internal.apt.meta.domain.InternalDomainMeta;
import org.seasar.doma.internal.apt.util.ElementKindUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.StringUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class InternalDomainMetaFactory
implements TypeElementMetaFactory<InternalDomainMeta> {
    private final Context ctx;

    public InternalDomainMetaFactory(Context ctx) {
        AssertionUtil.assertNotNull(ctx);
        this.ctx = ctx;
    }

    @Override
    public InternalDomainMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull(classElement);
        DomainAnnot domainAnnot = this.ctx.getAnnotations().newDomainAnnot(classElement);
        if (domainAnnot == null) {
            throw new AptIllegalStateException("domainAnnot");
        }
        InternalDomainMeta domainMeta = new InternalDomainMeta(classElement, classElement.asType());
        domainMeta.setDomainAnnot(domainAnnot);
        Strategy strategy = this.createStrategy(classElement, domainMeta);
        strategy.doTypeParameters(classElement, domainMeta);
        strategy.doWrapperCtType(classElement, domainMeta);
        strategy.validateAcceptNull(classElement, domainMeta);
        strategy.validateClass(classElement, domainMeta);
        strategy.validateInitializer(classElement, domainMeta);
        strategy.validateAccessorMethod(classElement, domainMeta);
        return domainMeta;
    }

    private Strategy createStrategy(TypeElement classElement, DomainMeta domainMeta) {
        ValueAnnot valueAnnot = this.ctx.getAnnotations().newValueAnnot(classElement);
        if (valueAnnot != null) {
            return new ValueStrategy(this.ctx, valueAnnot);
        }
        return new DefaultStrategy(this.ctx);
    }

    protected static class ValueStrategy
    extends DefaultStrategy {
        final ValueAnnot valueAnnot;

        ValueStrategy(Context ctx, ValueAnnot valueAnnot) {
            super(ctx);
            AssertionUtil.assertNotNull(valueAnnot);
            this.valueAnnot = valueAnnot;
        }

        @Override
        public void validateInitializer(TypeElement classElement, DomainMeta domainMeta) {
            if (!this.valueAnnot.getStaticConstructorValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4428, classElement, this.valueAnnot.getAnnotationMirror(), this.valueAnnot.getStaticConstructor(), new Object[0]);
            }
        }

        @Override
        public void validateAccessorMethod(TypeElement classElement, InternalDomainMeta domainMeta) {
            VariableElement field = this.findSingleField(classElement, domainMeta);
            String accessorMethod = this.inferAccessorMethod(field);
            if (!accessorMethod.equals(domainMeta.getAccessorMethod())) {
                DomainAnnot domainAnnot = domainMeta.getDomainAnnot();
                throw new AptException((MessageResource)Message.DOMA4429, classElement, domainAnnot.getAnnotationMirror(), domainAnnot.getAccessorMethod(), new Object[0]);
            }
        }

        String inferAccessorMethod(VariableElement field) {
            String name = field.getSimpleName().toString();
            String capitalizedName = StringUtil.capitalize(name);
            if (field.asType().getKind() == TypeKind.BOOLEAN) {
                if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
                    return name;
                }
                return "is" + capitalizedName;
            }
            return "get" + capitalizedName;
        }

        VariableElement findSingleField(TypeElement classElement, DomainMeta domainMeta) {
            List fields = ElementFilter.fieldsIn(classElement.getEnclosedElements()).stream().filter(field -> !field.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
            if (fields.size() == 0) {
                throw new AptException((MessageResource)Message.DOMA4430, classElement, new Object[0]);
            }
            if (fields.size() > 1) {
                throw new AptException((MessageResource)Message.DOMA4431, classElement, new Object[0]);
            }
            VariableElement field2 = (VariableElement)fields.get(0);
            if (!this.ctx.getMoreTypes().isAssignableWithErasure(field2.asType(), domainMeta.getValueType())) {
                throw new AptException((MessageResource)Message.DOMA4432, field2, new Object[]{field2.asType(), domainMeta.getValueType()});
            }
            return field2;
        }
    }

    protected static class DefaultStrategy
    implements Strategy {
        final Context ctx;

        DefaultStrategy(Context ctx) {
            AssertionUtil.assertNotNull(ctx);
            this.ctx = ctx;
        }

        @Override
        public void doTypeParameters(TypeElement classElement, InternalDomainMeta domainMeta) {
            TypeParametersDef typeParametersDef = this.ctx.getMoreElements().getTypeParametersDef(classElement);
            domainMeta.setTypeParametersDef(typeParametersDef);
        }

        @Override
        public void doWrapperCtType(TypeElement classElement, InternalDomainMeta domainMeta) {
            BasicCtType basicCtType = this.ctx.getCtTypes().newBasicCtType(domainMeta.getValueType());
            if (basicCtType == null) {
                DomainAnnot domainAnnot = domainMeta.getDomainAnnot();
                throw new AptException((MessageResource)Message.DOMA4102, classElement, domainAnnot.getAnnotationMirror(), domainAnnot.getValueType(), new Object[]{domainAnnot.getValueTypeValue()});
            }
            domainMeta.setBasicCtType(basicCtType);
        }

        @Override
        public void validateAcceptNull(TypeElement classElement, InternalDomainMeta domainMeta) {
            if (domainMeta.getBasicCtType().isPrimitive() && domainMeta.getAcceptNull()) {
                DomainAnnot domainAnnot = domainMeta.getDomainAnnot();
                throw new AptException((MessageResource)Message.DOMA4251, classElement, domainAnnot.getAnnotationMirror(), domainAnnot.getAcceptNull(), new Object[0]);
            }
        }

        @Override
        public void validateClass(TypeElement classElement, InternalDomainMeta domainMeta) {
            ElementKind kind = classElement.getKind();
            if (kind == ElementKind.CLASS || ElementKindUtil.isRecord(kind)) {
                if (domainMeta.providesConstructor() && classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new AptException((MessageResource)Message.DOMA4132, classElement, new Object[0]);
                }
                if (classElement.getNestingKind().isNested()) {
                    this.validateEnclosingElement(classElement);
                }
            } else if (kind == ElementKind.ENUM) {
                if (domainMeta.providesConstructor()) {
                    DomainAnnot domainAnnot = domainMeta.getDomainAnnot();
                    throw new AptException((MessageResource)Message.DOMA4184, classElement, domainAnnot.getAnnotationMirror(), domainAnnot.getFactoryMethod(), new Object[0]);
                }
                if (classElement.getNestingKind().isNested()) {
                    this.validateEnclosingElement(classElement);
                }
            } else if (kind == ElementKind.INTERFACE) {
                if (domainMeta.providesConstructor()) {
                    throw new AptException((MessageResource)Message.DOMA4268, classElement, new Object[0]);
                }
                if (classElement.getNestingKind().isNested()) {
                    this.validateEnclosingElement(classElement);
                }
            } else {
                DomainAnnot domainAnnot = domainMeta.getDomainAnnot();
                throw new AptException((MessageResource)Message.DOMA4105, (Element)classElement, domainAnnot.getAnnotationMirror(), new Object[0]);
            }
        }

        void validateEnclosingElement(Element element) {
            TypeElement typeElement = this.ctx.getMoreElements().toTypeElement(element);
            if (typeElement == null) {
                return;
            }
            String simpleName = typeElement.getSimpleName().toString();
            if (simpleName.contains("$") || simpleName.contains("__")) {
                throw new AptException((MessageResource)Message.DOMA4277, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.TOP_LEVEL) {
                return;
            }
            if (nestingKind == NestingKind.MEMBER) {
                Set<Modifier> modifiers = typeElement.getModifiers();
                if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                    throw new AptException((MessageResource)Message.DOMA4275, typeElement, new Object[]{typeElement.getQualifiedName()});
                }
            } else {
                throw new AptException((MessageResource)Message.DOMA4276, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            this.validateEnclosingElement(typeElement.getEnclosingElement());
        }

        @Override
        public void validateInitializer(TypeElement classElement, DomainMeta domainMeta) {
            if (domainMeta.providesConstructor()) {
                this.validateConstructor(classElement, domainMeta);
            } else {
                this.validateFactoryMethod(classElement, domainMeta);
            }
        }

        void validateConstructor(TypeElement classElement, DomainMeta domainMeta) {
            for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
                List<? extends VariableElement> parameters;
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || (parameters = constructor.getParameters()).size() != 1) continue;
                TypeMirror parameterType = this.ctx.getMoreTypes().erasure(parameters.get(0).asType());
                if (!this.ctx.getMoreTypes().isSameTypeWithErasure(parameterType, domainMeta.getValueType())) continue;
                return;
            }
            throw new AptException((MessageResource)Message.DOMA4103, classElement, new Object[]{domainMeta.getValueType()});
        }

        void validateFactoryMethod(TypeElement classElement, DomainMeta domainMeta) {
            block0: for (ExecutableElement method : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
                if (!method.getSimpleName().contentEquals(domainMeta.getFactoryMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getModifiers().contains((Object)Modifier.STATIC) || method.getParameters().size() != 1) continue;
                TypeMirror parameterType = method.getParameters().get(0).asType();
                if (!this.ctx.getMoreTypes().isAssignableWithErasure(domainMeta.getValueType(), parameterType)) continue;
                TypeMirror returnType = this.ctx.getMoreTypes().erasure(method.getReturnType());
                if (!this.ctx.getMoreTypes().isAssignableWithErasure(returnType, domainMeta.getType())) continue;
                List<? extends TypeParameterElement> classTypeParams = classElement.getTypeParameters();
                List<? extends TypeParameterElement> methodTypeParams = method.getTypeParameters();
                if (classTypeParams.size() != methodTypeParams.size()) continue;
                Iterator<? extends TypeParameterElement> cit = classTypeParams.iterator();
                Iterator<? extends TypeParameterElement> mit = methodTypeParams.iterator();
                while (cit.hasNext() && mit.hasNext()) {
                    TypeParameterElement classTypeParam = cit.next();
                    TypeParameterElement methodTypeParam = mit.next();
                    if (this.ctx.getMoreTypes().isSameTypeWithErasure(classTypeParam.asType(), methodTypeParam.asType())) continue;
                    continue block0;
                }
                return;
            }
            throw new AptException((MessageResource)Message.DOMA4106, classElement, new Object[]{domainMeta.getFactoryMethod(), classElement.asType(), domainMeta.getValueType()});
        }

        @Override
        public void validateAccessorMethod(TypeElement classElement, InternalDomainMeta domainMeta) {
            TypeElement typeElement = classElement;
            TypeMirror typeMirror = classElement.asType();
            while (typeElement != null && typeMirror.getKind() != TypeKind.NONE) {
                for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    TypeMirror inferredReturnType;
                    if (!method.getSimpleName().contentEquals(domainMeta.getAccessorMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getParameters().isEmpty()) continue;
                    TypeMirror returnType = method.getReturnType();
                    if (this.ctx.getMoreTypes().isAssignableWithErasure(this.ctx.getMoreTypes().erasure(returnType), domainMeta.getValueType())) {
                        return;
                    }
                    TypeVariable typeVariable = this.ctx.getMoreTypes().toTypeVariable(returnType);
                    if (typeVariable == null || (inferredReturnType = this.inferType(typeVariable, typeElement, typeMirror)) == null || !this.ctx.getMoreTypes().isAssignableWithErasure(inferredReturnType, domainMeta.getValueType())) continue;
                    return;
                }
                typeMirror = typeElement.getSuperclass();
                typeElement = this.ctx.getMoreTypes().toTypeElement(typeMirror);
            }
            throw new AptException((MessageResource)Message.DOMA4104, classElement, new Object[]{domainMeta.getAccessorMethod(), domainMeta.getValueType()});
        }

        TypeMirror inferType(TypeVariable typeVariable, TypeElement classElement, TypeMirror classMirror) {
            DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(classMirror);
            if (declaredType == null) {
                return null;
            }
            List<? extends TypeMirror> args = declaredType.getTypeArguments();
            if (args.isEmpty()) {
                return null;
            }
            int argsSize = args.size();
            int index = 0;
            for (TypeParameterElement typeParameterElement : classElement.getTypeParameters()) {
                if (index >= argsSize) break;
                if (this.ctx.getMoreTypes().isSameTypeWithErasure((TypeMirror)typeVariable, typeParameterElement.asType())) {
                    return args.get(index);
                }
                ++index;
            }
            return null;
        }
    }

    static interface Strategy {
        public void doTypeParameters(TypeElement var1, InternalDomainMeta var2);

        public void doWrapperCtType(TypeElement var1, InternalDomainMeta var2);

        public void validateAcceptNull(TypeElement var1, InternalDomainMeta var2);

        public void validateClass(TypeElement var1, InternalDomainMeta var2);

        public void validateInitializer(TypeElement var1, DomainMeta var2);

        public void validateAccessorMethod(TypeElement var1, InternalDomainMeta var2);
    }
}

