/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.annot.EmbeddableAnnot;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableConstructorMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.util.AssertionUtil;

public class EmbeddableMeta
implements TypeElementMeta {
    private final EmbeddableAnnot embeddableAnnot;
    private final TypeElement typeElement;
    private final TypeMirror type;
    private final List<EmbeddablePropertyMeta> propertyMetas = new ArrayList<EmbeddablePropertyMeta>();
    private EmbeddableConstructorMeta constructorMeta;
    private boolean error;

    public EmbeddableMeta(EmbeddableAnnot embeddableAnnot, TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)embeddableAnnot, (Object)typeElement);
        this.embeddableAnnot = embeddableAnnot;
        this.typeElement = typeElement;
        this.type = typeElement.asType();
    }

    public EmbeddableAnnot getEmbeddableAnnot() {
        return this.embeddableAnnot;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public void addEmbeddablePropertyMeta(EmbeddablePropertyMeta propertyMeta) {
        this.propertyMetas.add(propertyMeta);
    }

    public List<EmbeddablePropertyMeta> getEmbeddablePropertyMetas() {
        if (this.constructorMeta != null) {
            return this.constructorMeta.getEmbeddablePropertyMetas();
        }
        return this.propertyMetas;
    }

    public void setConstructorMeta(EmbeddableConstructorMeta constructorMeta) {
        this.constructorMeta = constructorMeta;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isAbstract() {
        return this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }
}

