/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.DomainConverters;
import org.seasar.doma.ExternalDomain;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.annot.DomainConvertersAnnot;
import org.seasar.doma.internal.apt.processor.AbstractProcessor;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

@SupportedAnnotationTypes(value={"org.seasar.doma.DomainConverters"})
@SupportedOptions(value={"doma.resources.dir", "doma.test", "doma.debug", "doma.config.path"})
public class DomainConvertersProcessor
extends AbstractProcessor {
    public DomainConvertersProcessor() {
        super(DomainConverters.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (TypeElement typeElement2 : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                this.handleTypeElement(typeElement2, t -> this.validate((TypeElement)t));
            }
        }
        return true;
    }

    protected void validate(TypeElement typeElement) {
        DomainConvertersAnnot convertersMirror = this.ctx.getAnnotations().newDomainConvertersAnnot(typeElement);
        for (TypeMirror convType : convertersMirror.getValueValue()) {
            TypeElement convElement = this.ctx.getMoreTypes().toTypeElement(convType);
            if (convElement == null || convElement.getAnnotation(ExternalDomain.class) != null) continue;
            throw new AptException((MessageResource)Message.DOMA4196, (Element)typeElement, convertersMirror.getAnnotationMirror(), new Object[]{convElement.getQualifiedName()});
        }
    }
}

