/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.generator.EntityDescGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityMetaFactory;
import org.seasar.doma.internal.apt.processor.AbstractGeneratingProcessor;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Entity"})
@SupportedOptions(value={"doma.entity.field.prefix", "doma.domain.converters", "doma.version.validation", "doma.resources.dir", "doma.lombok.Value", "doma.lombok.AllArgsConstructor", "doma.test", "doma.debug", "doma.config.path"})
public class EntityProcessor
extends AbstractGeneratingProcessor<EntityMeta> {
    public EntityProcessor() {
        super(Entity.class);
    }

    protected EntityMetaFactory createTypeElementMetaFactory() {
        return new EntityMetaFactory(this.ctx);
    }

    @Override
    protected ClassName createClassName(TypeElement typeElement, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newEntityDescClassName(binaryName);
    }

    @Override
    protected Generator createGenerator(ClassName className, Printer printer, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new EntityDescGenerator(this.ctx, className, printer, meta);
    }
}

