/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.AbstractParameterBinder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.JdbcMappable;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.ListParameter;
import org.seasar.doma.jdbc.OutParameter;
import org.seasar.doma.jdbc.ResultListParameter;
import org.seasar.doma.jdbc.SingleResultParameter;
import org.seasar.doma.jdbc.SqlParameter;
import org.seasar.doma.jdbc.SqlParameterVisitor;
import org.seasar.doma.jdbc.command.JdbcOutParameterRegistrar;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.wrapper.Wrapper;

public class CallableSqlParameterBinder
extends AbstractParameterBinder<CallableStatement, SqlParameter> {
    protected final Query query;

    public CallableSqlParameterBinder(Query query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    @Override
    public void bind(CallableStatement callableStatement, List<? extends SqlParameter> parameters) throws SQLException {
        AssertionUtil.assertNotNull((Object)callableStatement, parameters);
        BindingVisitor visitor = new BindingVisitor(this.query, callableStatement);
        for (SqlParameter sqlParameter : parameters) {
            sqlParameter.accept(visitor, null);
        }
    }

    protected class BindingVisitor
    implements SqlParameterVisitor<Void, Void, SQLException> {
        protected final Dialect dialect;
        protected final JdbcMappingVisitor jdbcMappingVisitor;
        protected final CallableStatement callableStatement;
        protected int index = 1;

        public BindingVisitor(Query query, CallableStatement callableStatement) {
            this.dialect = query.getConfig().getDialect();
            this.jdbcMappingVisitor = this.dialect.getJdbcMappingVisitor();
            this.callableStatement = callableStatement;
        }

        @Override
        public <BASIC> Void visitInParameter(InParameter<BASIC> parameter, Void p) throws SQLException {
            this.bindInParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <BASIC> Void visitOutParameter(OutParameter<BASIC> parameter, Void p) throws SQLException {
            this.registerOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <BASIC, INOUT extends InParameter<BASIC> & OutParameter<BASIC>> Void visitInOutParameter(INOUT parameter, Void p) throws SQLException {
            this.bindInParameter(parameter);
            this.registerOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <ELEMENT> Void visitListParameter(ListParameter<ELEMENT> parameter, Void p) throws SQLException {
            this.registerListParameter(parameter);
            return null;
        }

        @Override
        public <BASIC, RESULT> Void visitSingleResultParameter(SingleResultParameter<BASIC, RESULT> parameter, Void p) throws SQLException {
            this.registerOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <ELEMENT> Void visitResultListParameter(ResultListParameter<ELEMENT> parameter, Void p) throws SQLException {
            this.registerListParameter(parameter);
            return null;
        }

        protected <BASIC> void bindInParameter(InParameter<BASIC> parameter) throws SQLException {
            CallableSqlParameterBinder.this.bindInParameter(this.callableStatement, parameter, this.index, this.jdbcMappingVisitor);
        }

        protected <BASIC> void registerOutParameter(JdbcMappable<BASIC> parameter) throws SQLException {
            Wrapper<BASIC> wrapper = parameter.getWrapper();
            wrapper.accept(this.jdbcMappingVisitor, new JdbcOutParameterRegistrar(this.callableStatement, this.index), parameter);
        }

        protected <ELEMENT> void registerListParameter(ListParameter<ELEMENT> parameter) throws SQLException {
            if (this.dialect.supportsResultSetReturningAsOutParameter()) {
                JdbcType<ResultSet> resultSetType = this.dialect.getResultSetType();
                resultSetType.registerOutParameter(this.callableStatement, this.index);
                ++this.index;
            }
        }
    }
}

