/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.doma.internal.jdbc.command.AbstractObjectProvider;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.ResultMappingException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.UnknownColumnHandler;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.Query;

public class EntityProvider<ENTITY>
extends AbstractObjectProvider<ENTITY> {
    protected final EntityType<ENTITY> entityType;
    protected final Query query;
    protected final boolean resultMappingEnsured;
    protected final JdbcMappingVisitor jdbcMappingVisitor;
    protected final UnknownColumnHandler unknownColumnHandler;
    protected Map<Integer, EntityPropertyType<ENTITY, ?>> indexMap;

    public EntityProvider(EntityType<ENTITY> entityType, Query query, boolean resultMappingEnsured) {
        AssertionUtil.assertNotNull(entityType, (Object)query);
        this.entityType = entityType;
        this.query = query;
        this.resultMappingEnsured = resultMappingEnsured;
        this.jdbcMappingVisitor = query.getConfig().getDialect().getJdbcMappingVisitor();
        this.unknownColumnHandler = query.getConfig().getUnknownColumnHandler();
    }

    @Override
    public ENTITY get(ResultSet resultSet) throws SQLException {
        return this.build(resultSet);
    }

    protected ENTITY build(ResultSet resultSet) throws SQLException {
        AssertionUtil.assertNotNull(resultSet);
        if (this.indexMap == null) {
            this.indexMap = this.createIndexMap(resultSet.getMetaData(), this.entityType);
        }
        HashMap states = new HashMap(this.indexMap.size());
        for (Map.Entry<Integer, EntityPropertyType<ENTITY, ?>> entry : this.indexMap.entrySet()) {
            Integer index = entry.getKey();
            EntityPropertyType<ENTITY, ?> propertyType = entry.getValue();
            Property<ENTITY, ?> property = propertyType.createProperty();
            this.fetch(resultSet, property, index, this.jdbcMappingVisitor);
            states.put(propertyType.getName(), property);
        }
        ENTITY entity = this.entityType.newEntity(states);
        if (!this.entityType.isImmutable()) {
            this.entityType.saveCurrentStates(entity);
        }
        return entity;
    }

    protected HashMap<Integer, EntityPropertyType<ENTITY, ?>> createIndexMap(ResultSetMetaData resultSetMeta, EntityType<ENTITY> entityType) throws SQLException {
        HashMap indexMap = new HashMap();
        HashMap<String, EntityPropertyType<ENTITY, ?>> columnNameMap = this.createColumnNameMap(entityType);
        HashSet unmappedPropertySet = this.resultMappingEnsured ? new HashSet(columnNameMap.values()) : Collections.emptySet();
        int count = resultSetMeta.getColumnCount();
        for (int i = 1; i < count + 1; ++i) {
            String columnName = resultSetMeta.getColumnLabel(i);
            String lowerCaseColumnName = columnName.toLowerCase();
            EntityPropertyType<ENTITY, ?> propertyType = columnNameMap.get(lowerCaseColumnName);
            if (propertyType == null) {
                if ("doma_rownumber_".equals(lowerCaseColumnName)) continue;
                this.unknownColumnHandler.handle(this.query, entityType, lowerCaseColumnName);
                continue;
            }
            unmappedPropertySet.remove(propertyType);
            indexMap.put(i, propertyType);
        }
        if (this.resultMappingEnsured && !unmappedPropertySet.isEmpty()) {
            this.throwResultMappingException(unmappedPropertySet);
        }
        return indexMap;
    }

    protected HashMap<String, EntityPropertyType<ENTITY, ?>> createColumnNameMap(EntityType<ENTITY> entityType) {
        Naming naming = this.query.getConfig().getNaming();
        List<EntityPropertyType<ENTITY, ?>> propertyTypes = entityType.getEntityPropertyTypes();
        HashMap result = new HashMap(propertyTypes.size());
        for (EntityPropertyType<ENTITY, ?> propertyType : propertyTypes) {
            String columnName = propertyType.getColumnName(naming::apply);
            result.put(columnName.toLowerCase(), propertyType);
        }
        return result;
    }

    protected void throwResultMappingException(Set<EntityPropertyType<ENTITY, ?>> unmappedPropertySet) {
        Naming naming = this.query.getConfig().getNaming();
        int size = unmappedPropertySet.size();
        ArrayList<String> unmappedPropertyNames = new ArrayList<String>(size);
        ArrayList<String> expectedColumnNames = new ArrayList<String>(size);
        for (EntityPropertyType<ENTITY, ?> propertyType : unmappedPropertySet) {
            unmappedPropertyNames.add(propertyType.getName());
            expectedColumnNames.add(propertyType.getColumnName(naming::apply));
        }
        Sql<?> sql = this.query.getSql();
        throw new ResultMappingException(this.query.getConfig().getExceptionSqlLogType(), this.entityType.getEntityClass().getName(), unmappedPropertyNames, expectedColumnNames, sql.getKind(), sql.getRawSql(), sql.getFormattedSql(), sql.getSqlFilePath());
    }
}

