/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.command.ResultSetRowIndexConsumer;
import org.seasar.doma.jdbc.query.SelectQuery;

public class ResultSetIterator<TARGET>
implements Iterator<TARGET> {
    protected final ResultSet resultSet;
    protected final SelectQuery query;
    protected final ResultSetRowIndexConsumer consumer;
    protected final ObjectProvider<TARGET> provider;
    protected boolean next;
    protected long index = -1L;

    public ResultSetIterator(ResultSet resultSet, SelectQuery query, ResultSetRowIndexConsumer consumer, ObjectProvider<TARGET> provider) throws SQLException {
        AssertionUtil.assertNotNull((Object)resultSet, (Object)query, (Object)consumer, provider);
        this.resultSet = resultSet;
        this.query = query;
        this.consumer = consumer;
        this.provider = provider;
        this.next = resultSet.next();
        consumer.accept(this.index, this.next);
        ++this.index;
    }

    @Override
    public boolean hasNext() {
        return this.next;
    }

    @Override
    public TARGET next() {
        TARGET result;
        try {
            result = this.provider.get(this.resultSet);
            this.next = this.resultSet.next();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        this.consumer.accept(this.index, this.next);
        ++this.index;
        return result;
    }

    public List<TARGET> toList() {
        ArrayList result = new ArrayList();
        this.forEachRemaining(result::add);
        return result;
    }

    protected static class SQLRuntimeException
    extends RuntimeException {
        protected SQLRuntimeException(SQLException cause) {
            super(cause);
        }

        @Override
        public SQLException getCause() {
            return (SQLException)super.getCause();
        }
    }
}

