/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.scalar;

import java.util.Optional;
import java.util.function.Supplier;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.wrapper.Wrapper;

public class BasicScalar<BASIC>
implements Scalar<BASIC, BASIC> {
    protected final Wrapper<BASIC> wrapper;

    public BasicScalar(Supplier<Wrapper<BASIC>> supplier) {
        AssertionUtil.assertNotNull(supplier);
        this.wrapper = supplier.get();
        AssertionUtil.assertNotNull(this.wrapper);
    }

    @Override
    public Optional<Class<?>> getDomainClass() {
        return Optional.empty();
    }

    @Override
    public BASIC cast(Object value) {
        return this.wrapper.getBasicClass().cast(value);
    }

    @Override
    public BASIC get() {
        return this.wrapper.get();
    }

    @Override
    public BASIC getDefault() {
        return this.wrapper.getDefault();
    }

    @Override
    public void set(BASIC value) {
        this.wrapper.set(value);
    }

    @Override
    public Wrapper<BASIC> getWrapper() {
        return this.wrapper;
    }

    public String toString() {
        return this.wrapper.toString();
    }
}

