/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.sql.ConvertToLogFormatFunction;
import org.seasar.doma.internal.jdbc.sql.SqlContext;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingFunction;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.wrapper.Wrapper;

public class PreparedSqlBuilder
implements SqlContext {
    protected final List<InParameter<?>> parameters = new ArrayList();
    protected final StringBuilder rawSql = new StringBuilder(200);
    protected final StringBuilder formattedSql = new StringBuilder(200);
    protected final Config config;
    protected final SqlKind kind;
    protected final SqlLogFormattingFunction formattingFunction;
    protected final SqlLogType sqlLogType;

    public PreparedSqlBuilder(Config config, SqlKind kind, SqlLogType sqlLogType) {
        AssertionUtil.assertNotNull((Object)config, (Object)kind, (Object)sqlLogType);
        this.config = config;
        this.kind = kind;
        this.sqlLogType = sqlLogType;
        this.formattingFunction = new ConvertToLogFormatFunction();
    }

    @Override
    public void appendSql(String sql) {
        this.rawSql.append(sql);
        this.formattedSql.append(sql);
    }

    @Override
    public void cutBackSql(int length) {
        this.rawSql.setLength(this.rawSql.length() - length);
        this.formattedSql.setLength(this.formattedSql.length() - length);
    }

    @Override
    public <BASIC> void appendParameter(InParameter<BASIC> parameter) {
        this.rawSql.append("?");
        Wrapper wrapper = parameter.getWrapper();
        this.formattedSql.append(wrapper.accept(this.config.getDialect().getSqlLogFormattingVisitor(), this.formattingFunction, null));
        this.parameters.add(parameter);
    }

    public PreparedSql build(Function<String, String> commenter) {
        AssertionUtil.assertNotNull(commenter);
        return new PreparedSql(this.kind, (CharSequence)this.rawSql, (CharSequence)this.formattedSql, null, (List<? extends InParameter<?>>)this.parameters, this.sqlLogType, commenter);
    }
}

