/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.OtherNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class ParensNode
extends AbstractSqlNode {
    protected final SqlLocation location;
    protected boolean attachedWithValue;
    protected boolean empty = true;
    protected OtherNode openedParensNode;
    protected OtherNode closedParensNode;

    public ParensNode(SqlLocation location) {
        AssertionUtil.assertNotNull(location);
        this.location = location;
        this.openedParensNode = OtherNode.of("(");
    }

    public boolean isAttachedWithValue() {
        return this.attachedWithValue;
    }

    public void setAttachedWithValue(boolean attachedWithValue) {
        this.attachedWithValue = attachedWithValue;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public OtherNode getOpenedFragmentNode() {
        return this.openedParensNode;
    }

    public OtherNode getClosedFragmentNode() {
        return this.closedParensNode;
    }

    public SqlLocation getLocation() {
        return this.location;
    }

    public void close() {
        this.closedParensNode = OtherNode.of(")");
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitParensNode(this, p);
    }
}

