/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.sql.SQLException;
import java.util.function.Supplier;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.message.Message;

public abstract class AbstractJdbcLogger<LEVEL>
implements JdbcLogger {
    protected LEVEL defaultLevel;

    protected AbstractJdbcLogger(LEVEL level) {
        if (level == null) {
            throw new DomaNullPointerException("level");
        }
        this.defaultLevel = level;
    }

    protected abstract void log(LEVEL var1, String var2, String var3, Throwable var4, Supplier<String> var5);

    @Override
    public void logDaoMethodEntering(String callerClassName, String callerMethodName, Object ... args) {
        this.logDaoMethodEntering(callerClassName, callerMethodName, args, this.defaultLevel, () -> Message.DOMA2220.getMessage(callerClassName, callerMethodName));
    }

    protected void logDaoMethodEntering(String callerClassName, String callerMethodName, Object[] args, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logDaoMethodExiting(String callerClassName, String callerMethodName, Object result) {
        this.logDaoMethodExiting(callerClassName, callerMethodName, result, this.defaultLevel, () -> Message.DOMA2221.getMessage(callerClassName, callerMethodName));
    }

    protected void logDaoMethodExiting(String callerClassName, String callerMethodName, Object result, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logDaoMethodThrowing(String callerClassName, String callerMethodName, RuntimeException e) {
        this.logDaoMethodThrowing(callerClassName, callerMethodName, e, this.defaultLevel, () -> Message.DOMA2222.getMessage(callerClassName, callerMethodName, e.getClass().getName()));
    }

    protected void logDaoMethodThrowing(String callerClassName, String callerMethodName, RuntimeException e, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logSqlExecutionSkipping(String callerClassName, String callerMethodName, SqlExecutionSkipCause cause) {
        this.logSqlExecutionSkipping(callerClassName, callerMethodName, cause, this.defaultLevel, () -> Message.DOMA2223.getMessage(callerClassName, callerMethodName, cause.name()));
    }

    protected void logSqlExecutionSkipping(String callerClassName, String callerMethodName, SqlExecutionSkipCause cause, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logSql(String callerClassName, String callerMethodName, Sql<?> sql) {
        this.logSql(callerClassName, callerMethodName, sql, this.defaultLevel, () -> Message.DOMA2076.getMessage(sql.getSqlFilePath(), this.getSqlText(sql)));
    }

    protected void logSql(String callerClassName, String callerMethodName, Sql<?> sql, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    protected String getSqlText(Sql<?> sql) {
        switch (sql.getSqlLogType()) {
            case RAW: {
                return sql.getRawSql();
            }
            case FORMATTED: {
                return sql.getFormattedSql();
            }
            case NONE: {
                return "";
            }
        }
        return (String)AssertionUtil.assertUnreachable();
    }

    @Override
    public void logTransactionBegun(String callerClassName, String callerMethodName, String transactionId) {
        this.logTransactionBegun(callerClassName, callerMethodName, transactionId, this.defaultLevel, () -> Message.DOMA2063.getMessage(transactionId));
    }

    protected void logTransactionBegun(String callerClassName, String callerMethodName, String transactionId, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logTransactionEnded(String callerClassName, String callerMethodName, String transactionId) {
        this.logTransactionEnded(callerClassName, callerMethodName, transactionId, this.defaultLevel, () -> Message.DOMA2064.getMessage(transactionId));
    }

    protected void logTransactionEnded(String callerClassName, String callerMethodName, String transactionId, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logTransactionSavepointCreated(String callerClassName, String callerMethodName, String transactionId, String savepointName) {
        this.logTransactionSavepointCreated(callerClassName, callerMethodName, transactionId, savepointName, this.defaultLevel, () -> Message.DOMA2065.getMessage(transactionId, savepointName));
    }

    protected void logTransactionSavepointCreated(String callerClassName, String callerMethodName, String transactionId, String savepointName, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logTransactionCommitted(String callerClassName, String callerMethodName, String transactionId) {
        this.logTransactionCommitted(callerClassName, callerMethodName, transactionId, this.defaultLevel, () -> Message.DOMA2067.getMessage(transactionId));
    }

    protected void logTransactionCommitted(String callerClassName, String callerMethodName, String transactionId, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logTransactionRolledback(String callerClassName, String callerMethodName, String transactionId) {
        this.logTransactionRolledback(callerClassName, callerMethodName, transactionId, this.defaultLevel, () -> Message.DOMA2068.getMessage(transactionId));
    }

    protected void logTransactionRolledback(String callerClassName, String callerMethodName, String transactionId, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logTransactionSavepointRolledback(String callerClassName, String callerMethodName, String transactionId, String savepointName) {
        this.logTransactionSavepointRolledback(callerClassName, callerMethodName, transactionId, savepointName, this.defaultLevel, () -> Message.DOMA2069.getMessage(transactionId, savepointName));
    }

    protected void logTransactionSavepointRolledback(String callerClassName, String callerMethodName, String transactionId, String savepointName, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, null, messageSupplier);
    }

    @Override
    public void logTransactionRollbackFailure(String callerClassName, String callerMethodName, String transactionId, SQLException e) {
        this.logTransactionRollbackFailure(callerClassName, callerMethodName, e, this.defaultLevel, () -> Message.DOMA2070.getMessage(transactionId));
    }

    protected void logTransactionRollbackFailure(String callerClassName, String callerMethodName, SQLException e, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, e, messageSupplier);
    }

    @Override
    public void logAutoCommitEnablingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logAutoCommitEnablingFailure(callerClassName, callerMethodName, e, this.defaultLevel, () -> Message.DOMA2071.getMessage(new Object[0]));
    }

    protected void logAutoCommitEnablingFailure(String callerClassName, String callerMethodName, SQLException e, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, e, messageSupplier);
    }

    @Override
    public void logTransactionIsolationSettingFailure(String callerClassName, String callerMethodName, int transactionIsolationLevel, SQLException e) {
        this.logTransactionIsolationSettingFailure(callerClassName, callerMethodName, transactionIsolationLevel, e, this.defaultLevel, () -> Message.DOMA2072.getMessage(transactionIsolationLevel));
    }

    protected void logTransactionIsolationSettingFailure(String callerClassName, String callerMethodName, int transactionIsolationLevel, SQLException e, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, e, messageSupplier);
    }

    @Override
    public void logConnectionClosingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logConnectionClosingFailure(callerClassName, callerMethodName, e, this.defaultLevel, () -> Message.DOMA2073.getMessage(new Object[0]));
    }

    protected void logConnectionClosingFailure(String callerClassName, String callerMethodName, SQLException e, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, e, messageSupplier);
    }

    @Override
    public void logStatementClosingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logStatementClosingFailure(callerClassName, callerMethodName, e, this.defaultLevel, () -> Message.DOMA2074.getMessage(new Object[0]));
    }

    protected void logStatementClosingFailure(String callerClassName, String callerMethodName, SQLException e, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, e, messageSupplier);
    }

    @Override
    public void logResultSetClosingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logResultSetClosingFailure(callerClassName, callerMethodName, e, this.defaultLevel, () -> Message.DOMA2075.getMessage(new Object[0]));
    }

    protected void logResultSetClosingFailure(String callerClassName, String callerMethodName, SQLException e, LEVEL level, Supplier<String> messageSupplier) {
        this.log(level, callerClassName, callerMethodName, e, messageSupplier);
    }
}

