/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import javax.sql.DataSource;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.CommandImplementors;
import org.seasar.doma.jdbc.Commenter;
import org.seasar.doma.jdbc.ConfigProvider;
import org.seasar.doma.jdbc.ConfigSupport;
import org.seasar.doma.jdbc.EntityListenerProvider;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.MapKeyNaming;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.QueryImplementors;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.UnknownColumnHandler;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.tx.TransactionManager;
import org.seasar.doma.message.Message;

public interface Config {
    public DataSource getDataSource();

    public Dialect getDialect();

    default public String getDataSourceName() {
        return this.getClass().getName();
    }

    default public SqlFileRepository getSqlFileRepository() {
        return ConfigSupport.defaultSqlFileRepository;
    }

    default public JdbcLogger getJdbcLogger() {
        return ConfigSupport.defaultJdbcLogger;
    }

    default public RequiresNewController getRequiresNewController() {
        return ConfigSupport.defaultRequiresNewController;
    }

    default public ClassHelper getClassHelper() {
        return ConfigSupport.defaultClassHelper;
    }

    default public CommandImplementors getCommandImplementors() {
        return ConfigSupport.defaultCommandImplementors;
    }

    default public QueryImplementors getQueryImplementors() {
        return ConfigSupport.defaultQueryImplementors;
    }

    default public SqlLogType getExceptionSqlLogType() {
        return SqlLogType.FORMATTED;
    }

    default public UnknownColumnHandler getUnknownColumnHandler() {
        return ConfigSupport.defaultUnknownColumnHandler;
    }

    default public Naming getNaming() {
        return ConfigSupport.defaultNaming;
    }

    default public MapKeyNaming getMapKeyNaming() {
        return ConfigSupport.defaultMapKeyNaming;
    }

    default public TransactionManager getTransactionManager() {
        throw new UnsupportedOperationException();
    }

    default public Commenter getCommenter() {
        return ConfigSupport.defaultCommenter;
    }

    default public int getMaxRows() {
        return 0;
    }

    default public int getFetchSize() {
        return 0;
    }

    default public int getQueryTimeout() {
        return 0;
    }

    default public int getBatchSize() {
        return 0;
    }

    default public EntityListenerProvider getEntityListenerProvider() {
        return ConfigSupport.defaultEntityListenerProvider;
    }

    public static Config get(Object provider) {
        if (provider instanceof ConfigProvider) {
            ConfigProvider p = (ConfigProvider)provider;
            return p.getConfig();
        }
        throw new DomaIllegalArgumentException("provider", Message.DOMA2218.getMessage("provider", ConfigProvider.class.getName()));
    }
}

