/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlExecutionException
extends JdbcException {
    private static final long serialVersionUID = 1L;
    protected final SqlKind kind;
    protected final String rawSql;
    protected final String formattedSql;
    protected final String sqlFilePath;
    protected final Throwable rootCause;

    public SqlExecutionException(SqlLogType logType, Sql<?> sql, Throwable cause, Throwable rootCause) {
        this(logType, sql.getKind(), sql.getRawSql(), sql.getFormattedSql(), sql.getSqlFilePath(), cause, rootCause);
    }

    public SqlExecutionException(SqlLogType logType, SqlKind kind, String rawSql, String formattedSql, String sqlFilePath, Throwable cause, Throwable rootCause) {
        super((MessageResource)Message.DOMA2009, cause, sqlFilePath, SqlExecutionException.choiceSql(logType, rawSql, formattedSql), cause, rootCause);
        this.kind = kind;
        this.rawSql = rawSql;
        this.formattedSql = formattedSql;
        this.sqlFilePath = sqlFilePath;
        this.rootCause = rootCause;
    }

    protected SqlExecutionException(MessageResource messageCode, SqlKind kind, String rawSql, String formattedSql, String sqlFilePath, Throwable cause, Throwable rootCause) {
        super(messageCode, cause, sqlFilePath, rawSql, cause, rootCause);
        this.kind = kind;
        this.rawSql = rawSql;
        this.formattedSql = null;
        this.sqlFilePath = sqlFilePath;
        this.rootCause = rootCause;
    }

    public SqlKind getKind() {
        return this.kind;
    }

    public String getRawSql() {
        return this.rawSql;
    }

    public String getFormattedSql() {
        return this.formattedSql;
    }

    public String getSqlFilePath() {
        return this.sqlFilePath;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }
}

