/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.builder.BatchBuildingHelper;
import org.seasar.doma.jdbc.builder.BatchParam;
import org.seasar.doma.jdbc.builder.ParamIndex;
import org.seasar.doma.jdbc.command.BatchModifyCommand;
import org.seasar.doma.jdbc.query.SqlBatchModifyQuery;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class BatchBuilder {
    final BatchBuildingHelper helper;
    final SqlBatchModifyQuery query;
    final ParamIndex paramIndex;
    final Map<Integer, String> paramNameMap;

    BatchBuilder(SqlBatchModifyQuery query) {
        this.helper = new BatchBuildingHelper();
        this.query = query;
        this.paramIndex = new ParamIndex();
        this.paramNameMap = new HashMap<Integer, String>();
    }

    BatchBuilder(BatchBuildingHelper builder, SqlBatchModifyQuery query, ParamIndex paramIndex, Map<Integer, String> paramNameMap) {
        this.helper = builder;
        this.query = query;
        this.paramIndex = paramIndex;
        this.paramNameMap = paramNameMap;
    }

    static BatchBuilder newInstance(SqlBatchModifyQuery query) {
        if (query == null) {
            throw new DomaNullPointerException("query");
        }
        if (query.getClassName() == null) {
            query.setCallerClassName(BatchBuilder.class.getName());
        }
        return new InitialBatchBuilder(query);
    }

    public abstract BatchBuilder sql(String var1);

    public abstract BatchBuilder removeLast();

    public <P> BatchBuilder param(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        return this.appendParam(paramClass, param, false);
    }

    public <P> BatchBuilder literal(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        return this.appendParam(paramClass, param, true);
    }

    abstract <P> BatchBuilder appendParam(Class<P> var1, P var2, boolean var3);

    BatchBuilder fixSql() {
        return new FixedBatchBuilder(this.helper, this.query, this.paramNameMap);
    }

    private void prepare() {
        this.query.clearParameters();
        for (BatchParam<?> p : this.helper.getParams()) {
            this.query.addParameter(p.name, p.paramClass, p.params);
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
    }

    int[] execute(Supplier<BatchModifyCommand<?>> commandFactory) {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("execute");
        }
        this.prepare();
        BatchModifyCommand<?> command = commandFactory.get();
        int[] result = command.execute();
        this.query.complete();
        return result;
    }

    List<? extends Sql<?>> getSqls() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSqls");
        }
        this.prepare();
        return this.query.getSqls();
    }

    private static class FixedBatchBuilder
    extends BatchBuilder {
        private FixedBatchBuilder(BatchBuildingHelper builder, SqlBatchModifyQuery query, Map<Integer, String> paramNameMap) {
            super(builder, query, new ParamIndex(), paramNameMap);
        }

        @Override
        public BatchBuilder sql(String sql) {
            return this;
        }

        @Override
        public BatchBuilder removeLast() {
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        <P> BatchBuilder appendParam(Class<P> paramClass, P param, boolean literal) {
            String paramName = (String)this.paramNameMap.get(this.paramIndex.getValue());
            if (paramName == null) {
                throw new JdbcException((MessageResource)Message.DOMA2231, new Object[0]);
            }
            BatchParam<?> batchParam = this.helper.getParam(paramName);
            if (literal != batchParam.literal) {
                throw new JdbcException((MessageResource)Message.DOMA2230, new Object[0]);
            }
            if (paramClass != batchParam.paramClass) {
                if (batchParam.paramClass == Object.class) {
                    BatchParam<P> newBatchParam = new BatchParam<P>(batchParam, paramClass);
                    newBatchParam.add(param);
                    this.helper.modifyParam(newBatchParam);
                } else {
                    if (param != null || paramClass != Object.class) throw new JdbcException((MessageResource)Message.DOMA2229, new Object[0]);
                    batchParam.add(null);
                }
            } else {
                BatchParam<?> castedBatchParam = batchParam;
                castedBatchParam.add(param);
            }
            this.paramIndex.increment();
            return this;
        }
    }

    private static class SubsequentBatchBuilder
    extends InitialBatchBuilder {
        SubsequentBatchBuilder(BatchBuildingHelper builder, SqlBatchModifyQuery query, ParamIndex paramIndex, Map<Integer, String> paramNameMap) {
            super(builder, query, paramIndex, paramNameMap);
        }

        @Override
        public BatchBuilder sql(String sql) {
            if (sql == null) {
                throw new DomaNullPointerException("sql");
            }
            this.helper.appendSql(sql);
            return this;
        }
    }

    private static class InitialBatchBuilder
    extends BatchBuilder {
        private InitialBatchBuilder(SqlBatchModifyQuery query) {
            super(query);
        }

        private InitialBatchBuilder(BatchBuildingHelper builder, SqlBatchModifyQuery query, ParamIndex paramIndex, Map<Integer, String> paramNameMap) {
            super(builder, query, paramIndex, paramNameMap);
        }

        @Override
        public BatchBuilder sql(String sql) {
            if (sql == null) {
                throw new DomaNullPointerException("sql");
            }
            this.helper.appendSqlWithLineSeparator(sql);
            return new SubsequentBatchBuilder(this.helper, this.query, this.paramIndex, this.paramNameMap);
        }

        @Override
        public BatchBuilder removeLast() {
            this.helper.removeLast();
            return new SubsequentBatchBuilder(this.helper, this.query, this.paramIndex, this.paramNameMap);
        }

        @Override
        <P> BatchBuilder appendParam(Class<P> paramClass, P param, boolean literal) {
            BatchParam<P> batchParam = new BatchParam<P>(paramClass, this.paramIndex, literal);
            batchParam.add(param);
            this.helper.appendParam(batchParam);
            this.paramNameMap.put(this.paramIndex.getValue(), batchParam.name);
            this.paramIndex.increment();
            return new SubsequentBatchBuilder(this.helper, this.query, this.paramIndex, this.paramNameMap);
        }
    }
}

