/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.ListIterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.id.ReservedIdProvider;
import org.seasar.doma.jdbc.query.AutoBatchModifyQuery;
import org.seasar.doma.jdbc.query.BatchInsertQuery;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoBatchInsertQuery<ENTITY>
extends AutoBatchModifyQuery<ENTITY>
implements BatchInsertQuery {
    protected GeneratedIdPropertyType<ENTITY, ?, ?> generatedIdPropertyType;
    protected IdGenerationConfig idGenerationConfig;
    protected boolean batchSupported = true;

    public AutoBatchInsertQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entities, (Object)this.sqls);
        int size = this.entities.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.executionSkipCause = null;
        this.currentEntity = this.entities.get(0);
        this.preInsert();
        this.prepareIdAndVersionPropertyTypes();
        this.prepareOptions();
        this.prepareTargetPropertyTypes();
        this.prepareIdValue();
        this.prepareVersionValue();
        this.prepareSql();
        this.entities.set(0, this.currentEntity);
        ListIterator<Object> it = this.entities.listIterator(1);
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preInsert();
            this.prepareIdValue();
            this.prepareVersionValue();
            this.prepareSql();
            it.set(this.currentEntity);
        }
        this.currentEntity = null;
        AssertionUtil.assertEquals(this.entities.size(), this.sqls.size());
    }

    protected void preInsert() {
        AutoBatchPreInsertContext context = new AutoBatchPreInsertContext(this.entityType, this.method, this.config);
        this.entityType.preInsert(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    @Override
    protected void prepareIdAndVersionPropertyTypes() {
        super.prepareIdAndVersionPropertyTypes();
        this.generatedIdPropertyType = this.entityType.getGeneratedIdPropertyType();
        if (this.generatedIdPropertyType != null && this.idGenerationConfig == null) {
            this.idGenerationConfig = new IdGenerationConfig(this.config, this.entityType, new ReservedIdProvider(this.config, this.entityType, this.entities.size()));
            this.generatedIdPropertyType.validateGenerationStrategy(this.idGenerationConfig);
            this.autoGeneratedKeysSupported = this.generatedIdPropertyType.isAutoGeneratedKeysSupported(this.idGenerationConfig);
            this.batchSupported = this.generatedIdPropertyType.isBatchSupported(this.idGenerationConfig);
        }
    }

    protected void prepareTargetPropertyTypes() {
        this.targetPropertyTypes = new ArrayList(this.entityType.getEntityPropertyTypes().size());
        for (EntityPropertyType propertyType : this.entityType.getEntityPropertyTypes()) {
            if (!propertyType.isInsertable()) continue;
            if (propertyType.isId()) {
                if (propertyType != this.generatedIdPropertyType || this.generatedIdPropertyType.isIncluded(this.idGenerationConfig)) {
                    this.targetPropertyTypes.add(propertyType);
                }
                if (this.generatedIdPropertyType != null) continue;
                Property<Object, ?> property = propertyType.createProperty();
                property.load(this.currentEntity);
                if (property.getWrapper().get() != null) continue;
                throw new JdbcException((MessageResource)Message.DOMA2020, this.entityType.getName(), propertyType.getName());
            }
            if (!this.isTargetPropertyName(propertyType.getName())) continue;
            this.targetPropertyTypes.add(propertyType);
        }
    }

    protected void prepareIdValue() {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            Object newEntity;
            this.currentEntity = newEntity = this.generatedIdPropertyType.preInsert(this.entityType, this.currentEntity, this.idGenerationConfig);
        }
    }

    protected void prepareVersionValue() {
        if (this.versionPropertyType != null) {
            this.currentEntity = this.versionPropertyType.setIfNecessary(this.entityType, this.currentEntity, 1);
        }
    }

    protected void prepareSql() {
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.BATCH_INSERT, this.sqlLogType);
        builder.appendSql("insert into ");
        builder.appendSql(this.entityType.getQualifiedTableName(naming::apply, dialect::applyQuote));
        builder.appendSql(" (");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendSql(p.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(") values (");
        for (EntityPropertyType propertyType : this.targetPropertyTypes) {
            Property property = propertyType.createProperty();
            property.load(this.currentEntity);
            builder.appendParameter(property.asInParameter());
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(")");
        PreparedSql sql = builder.build(this::comment);
        this.sqls.add(sql);
    }

    @Override
    public boolean isBatchSupported() {
        return this.batchSupported;
    }

    @Override
    public void generateId(Statement statement, int index) {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            ENTITY newEntity = this.generatedIdPropertyType.postInsert(this.entityType, this.entities.get(index), this.idGenerationConfig, statement);
            this.entities.set(index, newEntity);
        }
    }

    @Override
    public void complete() {
        ListIterator<Object> it = this.entities.listIterator();
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.postInsert();
            it.set(this.currentEntity);
        }
    }

    protected void postInsert() {
        AutoBatchPostInsertContext context = new AutoBatchPostInsertContext(this.entityType, this.method, this.config);
        this.entityType.postInsert(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    protected static class AutoBatchPostInsertContext<E>
    extends AbstractPostInsertContext<E> {
        public AutoBatchPostInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class AutoBatchPreInsertContext<E>
    extends AbstractPreInsertContext<E> {
        public AutoBatchPreInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }
}

