/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.query.AutoModifyQuery;
import org.seasar.doma.jdbc.query.InsertQuery;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoInsertQuery<ENTITY>
extends AutoModifyQuery<ENTITY>
implements InsertQuery {
    protected boolean nullExcluded;
    protected GeneratedIdPropertyType<ENTITY, ?, ?> generatedIdPropertyType;
    protected IdGenerationConfig idGenerationConfig;

    public AutoInsertQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entityType, this.entity);
        this.executable = true;
        this.preInsert();
        this.prepareSpecialPropertyTypes();
        this.prepareOptions();
        this.prepareTargetPropertyType();
        this.prepareIdValue();
        this.prepareVersionValue();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preInsert() {
        AutoPreInsertContext context = new AutoPreInsertContext(this.entityType, this.method, this.config);
        this.entityType.preInsert(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
    }

    @Override
    protected void prepareSpecialPropertyTypes() {
        super.prepareSpecialPropertyTypes();
        this.generatedIdPropertyType = this.entityType.getGeneratedIdPropertyType();
        if (this.generatedIdPropertyType != null) {
            this.idGenerationConfig = new IdGenerationConfig(this.config, this.entityType);
            this.generatedIdPropertyType.validateGenerationStrategy(this.idGenerationConfig);
            this.autoGeneratedKeysSupported = this.generatedIdPropertyType.isAutoGeneratedKeysSupported(this.idGenerationConfig);
        }
    }

    protected void prepareTargetPropertyType() {
        this.targetPropertyTypes = new ArrayList(this.entityType.getEntityPropertyTypes().size());
        for (EntityPropertyType propertyType : this.entityType.getEntityPropertyTypes()) {
            if (!propertyType.isInsertable()) continue;
            Property<Object, ?> property = propertyType.createProperty();
            property.load(this.entity);
            if (propertyType.isId()) {
                if (propertyType != this.generatedIdPropertyType || this.generatedIdPropertyType.isIncluded(this.idGenerationConfig)) {
                    this.targetPropertyTypes.add(propertyType);
                }
                if (this.generatedIdPropertyType != null || property.getWrapper().get() != null) continue;
                throw new JdbcException((MessageResource)Message.DOMA2020, this.entityType.getName(), propertyType.getName());
            }
            if (propertyType.isVersion()) {
                this.targetPropertyTypes.add(propertyType);
                continue;
            }
            if (this.nullExcluded && property.getWrapper().get() == null || !this.isTargetPropertyName(propertyType.getName())) continue;
            this.targetPropertyTypes.add(propertyType);
        }
    }

    protected void prepareIdValue() {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            Object newEntity;
            this.entity = newEntity = this.generatedIdPropertyType.preInsert(this.entityType, this.entity, this.idGenerationConfig);
        }
    }

    protected void prepareVersionValue() {
        if (this.versionPropertyType != null) {
            this.entity = this.versionPropertyType.setIfNecessary(this.entityType, this.entity, 1);
        }
    }

    protected void prepareSql() {
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.INSERT, this.sqlLogType);
        builder.appendSql("insert into ");
        builder.appendSql(this.entityType.getQualifiedTableName(naming::apply, dialect::applyQuote));
        builder.appendSql(" (");
        for (EntityPropertyType propertyType : this.targetPropertyTypes) {
            builder.appendSql(propertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(") values (");
        for (EntityPropertyType propertyType : this.targetPropertyTypes) {
            Property property = propertyType.createProperty();
            property.load(this.entity);
            builder.appendParameter(property.asInParameter());
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(")");
        this.sql = builder.build(this::comment);
    }

    @Override
    public void generateId(Statement statement) {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            Object newEntity;
            this.entity = newEntity = this.generatedIdPropertyType.postInsert(this.entityType, this.entity, this.idGenerationConfig, statement);
        }
    }

    @Override
    public void complete() {
        this.postInsert();
    }

    protected void postInsert() {
        AutoPostInsertContext context = new AutoPostInsertContext(this.entityType, this.method, this.config);
        this.entityType.postInsert(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
    }

    public void setNullExcluded(boolean nullExcluded) {
        this.nullExcluded = nullExcluded;
    }

    protected static class AutoPostInsertContext<E>
    extends AbstractPostInsertContext<E> {
        public AutoPostInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class AutoPreInsertContext<E>
    extends AbstractPreInsertContext<E> {
        public AutoPreInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }
}

