/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.AutoModifyQuery;
import org.seasar.doma.jdbc.query.UpdateQuery;
import org.seasar.doma.jdbc.query.UpdateQueryHelper;

public class AutoUpdateQuery<ENTITY>
extends AutoModifyQuery<ENTITY>
implements UpdateQuery {
    protected boolean nullExcluded;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;
    protected boolean unchangedPropertyIncluded;
    protected UpdateQueryHelper<ENTITY> helper;

    public AutoUpdateQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entityType, this.entity);
        this.setupHelper();
        this.preUpdate();
        this.prepareSpecialPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareTargetPropertyTypes();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void setupHelper() {
        this.helper = new UpdateQueryHelper(this.config, this.entityType, this.includedPropertyNames, this.excludedPropertyNames, this.nullExcluded, this.versionIgnored, this.optimisticLockExceptionSuppressed, this.unchangedPropertyIncluded);
    }

    protected void preUpdate() {
        List targetPropertyTypes = this.helper.getTargetPropertyTypes(this.entity);
        AutoPreUpdateContext context = new AutoPreUpdateContext(this.entityType, this.method, this.config, targetPropertyTypes);
        this.entityType.preUpdate(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
    }

    protected void prepareOptimisticLock() {
        if (!this.versionIgnored && this.versionPropertyType != null && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareTargetPropertyTypes() {
        this.targetPropertyTypes = this.helper.getTargetPropertyTypes(this.entity);
        if (!this.targetPropertyTypes.isEmpty()) {
            this.executable = true;
            this.sqlExecutionSkipCause = null;
        }
    }

    protected void prepareSql() {
        Property property;
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.UPDATE, this.sqlLogType);
        builder.appendSql("update ");
        builder.appendSql(this.entityType.getQualifiedTableName(naming::apply, dialect::applyQuote));
        builder.appendSql(" set ");
        this.helper.populateValues(this.entity, this.targetPropertyTypes, this.versionPropertyType, builder);
        boolean whereClauseAppended = false;
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            whereClauseAppended = true;
            for (EntityPropertyType propertyType : this.idPropertyTypes) {
                Property property2 = propertyType.createProperty();
                property2.load(this.entity);
                builder.appendSql(propertyType.getColumnName(naming::apply, dialect::applyQuote));
                builder.appendSql(" = ");
                builder.appendParameter(property2.asInParameter());
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (!this.versionIgnored && this.versionPropertyType != null) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.versionPropertyType.createProperty();
            property.load(this.entity);
            builder.appendSql(this.versionPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        if (this.tenantIdPropertyType != null) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.tenantIdPropertyType.createProperty();
            property.load(this.entity);
            builder.appendSql(this.tenantIdPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        this.sql = builder.build(this::comment);
    }

    @Override
    public void incrementVersion() {
        if (!this.versionIgnored && this.versionPropertyType != null) {
            this.entity = this.versionPropertyType.increment(this.entityType, this.entity);
        }
    }

    @Override
    public void complete() {
        this.postUpdate();
    }

    protected void postUpdate() {
        List<EntityPropertyType<VersionPropertyType, ?>> targetPropertyTypes = this.helper.getTargetPropertyTypes(this.entity);
        if (!this.versionIgnored && this.versionPropertyType != null) {
            targetPropertyTypes.add(this.versionPropertyType);
        }
        AutoPostUpdateContext context = new AutoPostUpdateContext(this.entityType, this.method, this.config, targetPropertyTypes);
        this.entityType.postUpdate(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
        this.entityType.saveCurrentStates(this.entity);
    }

    public void setNullExcluded(boolean nullExcluded) {
        this.nullExcluded = nullExcluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    public void setUnchangedPropertyIncluded(Boolean unchangedPropertyIncluded) {
        this.unchangedPropertyIncluded = unchangedPropertyIncluded;
    }

    protected static class AutoPostUpdateContext<E>
    extends AbstractPostUpdateContext<E> {
        protected final Set<String> changedPropertyNames;

        public AutoPostUpdateContext(EntityType<E> entityType, Method method, Config config, List<EntityPropertyType<E, ?>> targetPropertyTypes) {
            super(entityType, method, config);
            AssertionUtil.assertNotNull(targetPropertyTypes);
            this.changedPropertyNames = new HashSet<String>(targetPropertyTypes.size());
            for (EntityPropertyType<E, ?> propertyType : targetPropertyTypes) {
                this.changedPropertyNames.add(propertyType.getName());
            }
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return this.changedPropertyNames.contains(propertyName);
        }
    }

    protected static class AutoPreUpdateContext<E>
    extends AbstractPreUpdateContext<E> {
        protected final Set<String> changedPropertyNames;

        public AutoPreUpdateContext(EntityType<E> entityType, Method method, Config config, List<EntityPropertyType<E, ?>> targetPropertyTypes) {
            super(entityType, method, config);
            AssertionUtil.assertNotNull(targetPropertyTypes);
            this.changedPropertyNames = new HashSet<String>(targetPropertyTypes.size());
            for (EntityPropertyType<E, ?> propertyType : targetPropertyTypes) {
                this.changedPropertyNames.add(propertyType.getName());
            }
        }

        @Override
        public boolean isEntityChanged() {
            return !this.changedPropertyNames.isEmpty();
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return this.changedPropertyNames.contains(propertyName);
        }
    }
}

