/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.SqlContext;
import org.seasar.doma.internal.jdbc.sql.node.ExpandNode;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.ModifyQuery;

public abstract class SqlFileModifyQuery
extends AbstractQuery
implements ModifyQuery {
    protected static final String[] EMPTY_STRINGS = new String[0];
    protected final SqlKind kind;
    protected String sqlFilePath;
    protected final Map<String, Value> parameters = new LinkedHashMap<String, Value>();
    protected PreparedSql sql;
    protected boolean optimisticLockCheckRequired;
    protected SqlLogType sqlLogType;
    protected String[] includedPropertyNames = EMPTY_STRINGS;
    protected String[] excludedPropertyNames = EMPTY_STRINGS;
    protected boolean executable;
    protected SqlExecutionSkipCause sqlExecutionSkipCause = SqlExecutionSkipCause.STATE_UNCHANGED;

    protected SqlFileModifyQuery(SqlKind kind) {
        AssertionUtil.assertNotNull((Object)kind);
        this.kind = kind;
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    protected void prepareSql() {
        SqlFile sqlFile = this.config.getSqlFileRepository().getSqlFile(this.method, this.sqlFilePath, this.config.getDialect());
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.parameters, this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, this.kind, sqlFile.getPath(), evaluator, this.sqlLogType, this::expandColumns, this::populateValues);
        this.sql = sqlBuilder.build(sqlFile.getSqlNode(), this::comment);
    }

    protected List<String> expandColumns(ExpandNode node) {
        throw new UnsupportedOperationException();
    }

    protected void populateValues(PopulateNode node, SqlContext context) {
        throw new UnsupportedOperationException();
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public void addParameter(String name, Class<?> type, Object value) {
        AssertionUtil.assertNotNull((Object)name, type);
        this.addParameterInternal(name, type, value);
    }

    public void addParameterInternal(String name, Class<?> type, Object value) {
        this.parameters.put(name, new Value(type, value));
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    public void setIncludedPropertyNames(String ... includedPropertyNames) {
        this.includedPropertyNames = includedPropertyNames;
    }

    public void setExcludedPropertyNames(String ... excludedPropertyNames) {
        this.excludedPropertyNames = excludedPropertyNames;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return this.sqlExecutionSkipCause;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return false;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }

    public abstract <E> void setEntityAndEntityType(String var1, E var2, EntityType<E> var3);

    public String toString() {
        return this.sql != null ? this.sql.toString() : null;
    }
}

