/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.List;
import java.util.function.Function;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.node.ExpandNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SelectOptionsAccessor;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.query.AbstractSelectQuery;

public class SqlSelectQuery
extends AbstractSelectQuery {
    protected SqlNode sqlNode;

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull(this.sqlNode);
    }

    @Override
    protected void prepareSql() {
        SqlNode transformedSqlNode = this.config.getDialect().transformSelectSqlNode(this.sqlNode, this.options);
        this.buildSql((evaluator, expander) -> {
            NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, SqlKind.SELECT, null, (ExpressionEvaluator)evaluator, this.sqlLogType, (Function<ExpandNode, List<String>>)expander);
            return sqlBuilder.build(transformedSqlNode, this::comment);
        });
    }

    @Override
    public void complete() {
        if (SelectOptionsAccessor.isCount(this.options)) {
            this.executeCount(this.sqlNode);
        }
    }

    public void setSqlNode(SqlNode sqlNode) {
        this.sqlNode = sqlNode;
    }
}

