/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.tx.LocalTransactionConnection;
import org.seasar.doma.jdbc.tx.TransactionNotYetBegunException;
import org.seasar.doma.message.Message;

public class LocalTransactionContext {
    private final List<String> savepointNames = new ArrayList<String>();
    private final Map<String, Savepoint> savepointMap = new HashMap<String, Savepoint>();
    private LocalTransactionConnection localTxConnection;
    private Supplier<LocalTransactionConnection> localTxConnectionSupplier;
    private String id;
    private boolean rollbackOnly;

    void begin(Supplier<LocalTransactionConnection> localTxConnectionSupplier) {
        AssertionUtil.assertNotNull(localTxConnectionSupplier);
        this.id = String.valueOf(System.identityHashCode(localTxConnectionSupplier));
        this.localTxConnectionSupplier = localTxConnectionSupplier;
    }

    void end() {
        this.id = null;
        this.localTxConnectionSupplier = null;
    }

    LocalTransactionConnection getConnection() {
        if (this.localTxConnection == null) {
            if (this.localTxConnectionSupplier == null) {
                throw new TransactionNotYetBegunException(Message.DOMA2048, new Object[0]);
            }
            this.localTxConnection = this.localTxConnectionSupplier.get();
        }
        return this.localTxConnection;
    }

    boolean hasConnection() {
        return this.localTxConnection != null;
    }

    Savepoint getSavepoint(String savepointName) {
        AssertionUtil.assertNotNull(savepointName);
        return this.savepointMap.get(savepointName);
    }

    void addSavepoint(String savepointName, Savepoint savepoint) {
        AssertionUtil.assertNotNull((Object)savepointName, (Object)savepoint);
        this.savepointNames.add(savepointName);
        this.savepointMap.put(savepointName, savepoint);
    }

    Savepoint releaseAndGetSavepoint(String savepointName) {
        AssertionUtil.assertNotNull(savepointName);
        Savepoint result = this.savepointMap.get(savepointName);
        if (result == null) {
            return null;
        }
        int pos = this.savepointNames.lastIndexOf(savepointName);
        if (pos > -1) {
            List<String> subList = this.savepointNames.subList(pos, this.savepointNames.size());
            for (String name : subList) {
                this.savepointMap.remove(name);
            }
            subList.clear();
        }
        return result;
    }

    String getId() {
        return this.id;
    }

    void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    boolean isRollbackOnly() {
        return this.rollbackOnly;
    }
}

