/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.MessageResource;

public final class Reporter {
    private Messager messager;

    Reporter(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)env);
        this.messager = env.getMessager();
    }

    public void debug(MessageResource messageResource, Object[] args) {
        AssertionUtil.assertNotNull((Object)messageResource, (Object[])args);
        this.messager.printMessage(Diagnostic.Kind.OTHER, messageResource.getMessage(args));
    }

    public void debug(CharSequence message) {
        AssertionUtil.assertNotNull((Object)message);
        this.messager.printMessage(Diagnostic.Kind.OTHER, message);
    }

    public void report(Diagnostic.Kind kind, MessageResource messageResource, Object[] args) {
        AssertionUtil.assertNotNull((Object)messageResource, (Object[])args);
        this.messager.printMessage(kind, messageResource.getMessage(args));
    }

    public void report(Diagnostic.Kind kind, MessageResource messageResource, Element element, Object[] args) {
        AssertionUtil.assertNotNull((Object)((Object)kind), (Object)element, (Object)args);
        this.messager.printMessage(kind, messageResource.getMessage(args), element);
    }

    public void report(Diagnostic.Kind kind, String message, Element element) {
        AssertionUtil.assertNotNull((Object)((Object)kind), (Object)message, (Object)element);
        this.messager.printMessage(kind, message, element);
    }

    public void report(AptException e) {
        AssertionUtil.assertNotNull((Object)((Object)e));
        this.messager.printMessage(e.getKind(), e.getMessage(), e.getElement(), e.getAnnotationMirror(), e.getAnnotationValue());
    }
}

