/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.id;

import org.seasar.doma.internal.apt.annot.TableGeneratorAnnot;
import org.seasar.doma.internal.apt.meta.id.IdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.id.IdGeneratorMetaVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public class TableIdGeneratorMeta
implements IdGeneratorMeta {
    private final TableGeneratorAnnot tableGeneratorAnnot;

    public TableIdGeneratorMeta(TableGeneratorAnnot tableGeneratorAnnot) {
        AssertionUtil.assertNotNull((Object)tableGeneratorAnnot);
        this.tableGeneratorAnnot = tableGeneratorAnnot;
    }

    public String getQualifiedTableName() {
        String schemaName;
        StringBuilder buf = new StringBuilder();
        String catalogName = this.tableGeneratorAnnot.getCatalogValue();
        if (!catalogName.isEmpty()) {
            buf.append(catalogName);
            buf.append(".");
        }
        if (!(schemaName = this.tableGeneratorAnnot.getCatalogValue()).isEmpty()) {
            buf.append(schemaName);
            buf.append(".");
        }
        buf.append(this.tableGeneratorAnnot.getTableValue());
        return buf.toString();
    }

    public String getPkColumnName() {
        return this.tableGeneratorAnnot.getPkColumnNameValue();
    }

    public String getValueColumnName() {
        return this.tableGeneratorAnnot.getValueColumnNameValue();
    }

    public String getPkColumnValue() {
        return this.tableGeneratorAnnot.getPkColumnValueValue();
    }

    public long getInitialValue() {
        return this.tableGeneratorAnnot.getInitialValueValue();
    }

    public long getAllocationSize() {
        return this.tableGeneratorAnnot.getAllocationSizeValue();
    }

    @Override
    public String getIdGeneratorClassName() {
        return this.tableGeneratorAnnot.getImplementerValue().toString();
    }

    @Override
    public <R, P> R accept(IdGeneratorMetaVisitor<R, P> visitor, P p) {
        return visitor.visistTableIdGeneratorMeta(this, p);
    }
}

