/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;

public class ScriptAnnot
extends AbstractAnnot {
    private static final String HALT_ON_ERROR = "haltOnError";
    private static final String BLOCK_DELIMITER = "blockDelimiter";
    private static final String SQL_LOG = "sqlLog";
    private final AnnotationValue haltOnError;
    private final AnnotationValue blockDelimiter;
    private final AnnotationValue sqlLog;

    ScriptAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.haltOnError = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)HALT_ON_ERROR);
        this.blockDelimiter = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)BLOCK_DELIMITER);
        this.sqlLog = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SQL_LOG);
    }

    public AnnotationValue getHaltOnError() {
        return this.haltOnError;
    }

    public AnnotationValue getBlockDelimiter() {
        return this.blockDelimiter;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public boolean getHaltOnErrorValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.haltOnError);
        if (value == null) {
            throw new AptIllegalStateException(HALT_ON_ERROR);
        }
        return value;
    }

    public String getBlockDelimiterValue() {
        String value = AnnotationValueUtil.toString(this.blockDelimiter);
        if (value == null) {
            throw new AptIllegalStateException(BLOCK_DELIMITER);
        }
        return value;
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException(SQL_LOG);
        }
        return SqlLogType.valueOf((String)enumConstant.getSimpleName().toString());
    }
}

