/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class MetamodelAnnot
extends AbstractAnnot {
    private static final String PREFIX = "prefix";
    private static final String SUFFIX = "suffix";
    private final AnnotationValue prefix;
    private final AnnotationValue suffix;

    MetamodelAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.prefix = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)PREFIX);
        this.suffix = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SUFFIX);
    }

    public AnnotationValue getPrefix() {
        return this.prefix;
    }

    public AnnotationValue getSuffix() {
        return this.suffix;
    }

    public String getPrefixValue() {
        String value = AnnotationValueUtil.toString(this.prefix);
        if (value == null) {
            throw new AptIllegalStateException(PREFIX);
        }
        return value;
    }

    public String getSuffixValue() {
        String value = AnnotationValueUtil.toString(this.suffix);
        if (value == null) {
            throw new AptIllegalStateException(SUFFIX);
        }
        return value;
    }
}

