/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.domain;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.DataTypeAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.def.TypeParametersDef;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.domain.DataTypeMeta;
import org.seasar.doma.internal.apt.util.ElementKindUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DataTypeMetaFactory
implements TypeElementMetaFactory<DataTypeMeta> {
    private final Context ctx;

    public DataTypeMetaFactory(Context ctx) {
        AssertionUtil.assertNotNull((Object)ctx);
        this.ctx = ctx;
    }

    @Override
    public DataTypeMeta createTypeElementMeta(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        DataTypeAnnot dataTypeAnnot = this.ctx.getAnnotations().newDataTypeAnnot(typeElement);
        if (dataTypeAnnot == null) {
            throw new AptIllegalStateException("dataTypeAnnot");
        }
        DataTypeMeta dataTypeMeta = new DataTypeMeta(typeElement, typeElement.asType(), dataTypeAnnot);
        this.validateTypeElement(typeElement, dataTypeMeta);
        this.doTypeParameters(typeElement, dataTypeMeta);
        this.doConstructor(typeElement, dataTypeMeta);
        return dataTypeMeta;
    }

    private void validateTypeElement(TypeElement typeElement, DataTypeMeta dataTypeMeta) {
        if (!ElementKindUtil.isRecord(typeElement.getKind())) {
            throw new AptException((MessageResource)Message.DOMA4449, typeElement, new Object[0]);
        }
        if (typeElement.getNestingKind().isNested()) {
            this.validateEnclosingElement(typeElement);
        }
    }

    void validateEnclosingElement(Element element) {
        TypeElement typeElement = this.ctx.getMoreElements().toTypeElement(element);
        if (typeElement == null) {
            return;
        }
        String simpleName = typeElement.getSimpleName().toString();
        if (simpleName.contains("$") || simpleName.contains("__")) {
            throw new AptException((MessageResource)Message.DOMA4450, typeElement, new Object[]{typeElement.getQualifiedName()});
        }
        NestingKind nestingKind = typeElement.getNestingKind();
        if (nestingKind == NestingKind.TOP_LEVEL) {
            return;
        }
        if (nestingKind == NestingKind.MEMBER) {
            Set<Modifier> modifiers = typeElement.getModifiers();
            if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                throw new AptException((MessageResource)Message.DOMA4451, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
        } else {
            throw new AptException((MessageResource)Message.DOMA4452, typeElement, new Object[]{typeElement.getQualifiedName()});
        }
        this.validateEnclosingElement(typeElement.getEnclosingElement());
    }

    public void doTypeParameters(TypeElement typeElement, DataTypeMeta dataTypeMeta) {
        TypeParametersDef typeParametersDef = this.ctx.getMoreElements().getTypeParametersDef(typeElement);
        dataTypeMeta.setTypeParametersDef(typeParametersDef);
    }

    private void doConstructor(TypeElement typeElement, DataTypeMeta dataTypeMeta) {
        List constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(c -> !c.getModifiers().contains((Object)Modifier.PRIVATE)).filter(c -> c.getParameters().size() == 1).collect(Collectors.toList());
        if (constructors.isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4453, typeElement, new Object[0]);
        }
        if (constructors.size() > 1) {
            throw new AptException((MessageResource)Message.DOMA4456, typeElement, new Object[0]);
        }
        ExecutableElement constructor = (ExecutableElement)constructors.iterator().next();
        VariableElement param = constructor.getParameters().iterator().next();
        if (param == null) {
            throw new AptIllegalStateException("param is null");
        }
        TypeMirror type = param.asType();
        BasicCtType basicCtType = this.ctx.getCtTypes().newBasicCtType(type);
        if (basicCtType == null) {
            throw new AptException((MessageResource)Message.DOMA4454, param, new Object[]{type});
        }
        dataTypeMeta.setBasicCtType(basicCtType);
        dataTypeMeta.setAccessorMethod(param.getSimpleName().toString());
    }
}

