/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.id;

import org.seasar.doma.internal.apt.annot.SequenceGeneratorAnnot;
import org.seasar.doma.internal.apt.meta.id.IdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.id.IdGeneratorMetaVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public class SequenceIdGeneratorMeta
implements IdGeneratorMeta {
    private final SequenceGeneratorAnnot sequenceGeneratorAnnot;

    public SequenceIdGeneratorMeta(SequenceGeneratorAnnot sequenceGeneratorAnnot) {
        AssertionUtil.assertNotNull((Object)sequenceGeneratorAnnot);
        this.sequenceGeneratorAnnot = sequenceGeneratorAnnot;
    }

    public String getQualifiedSequenceName() {
        String schemaName;
        StringBuilder buf = new StringBuilder();
        String catalogName = this.sequenceGeneratorAnnot.getCatalogValue();
        if (!catalogName.isEmpty()) {
            buf.append(catalogName);
            buf.append(".");
        }
        if (!(schemaName = this.sequenceGeneratorAnnot.getSchemaValue()).isEmpty()) {
            buf.append(schemaName);
            buf.append(".");
        }
        buf.append(this.sequenceGeneratorAnnot.getSequenceValue());
        return buf.toString();
    }

    public long getInitialValue() {
        return this.sequenceGeneratorAnnot.getInitialValueValue();
    }

    public long getAllocationSize() {
        return this.sequenceGeneratorAnnot.getAllocationSizeValue();
    }

    @Override
    public String getIdGeneratorClassName() {
        return this.sequenceGeneratorAnnot.getImplementerValue().toString();
    }

    @Override
    public <R, P> R accept(IdGeneratorMetaVisitor<R, P> visitor, P p) {
        return visitor.visitSequenceIdGeneratorMeta(this, p);
    }
}

