/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.LinkedHashMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AbstractSqlFileQueryMeta;
import org.seasar.doma.internal.apt.validator.SqlValidator;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.IOUtil;
import org.seasar.doma.internal.util.StringUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

abstract class AbstractSqlFileQueryMetaFactory<M extends AbstractSqlFileQueryMeta>
extends AbstractQueryMetaFactory<M> {
    AbstractSqlFileQueryMetaFactory(Context ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    void doSqlTemplate(M queryMeta, boolean expandable, boolean populatable) {
        if (!this.ctx.getOptions().getSqlValidation()) {
            return;
        }
        SqlAnnot sqlAnnot = ((AbstractSqlFileQueryMeta)queryMeta).getSqlAnnot();
        if (sqlAnnot == null) {
            this.processSqlFiles(queryMeta, expandable, populatable);
        } else {
            String sql = sqlAnnot.getValueValue();
            String path = ((AbstractSqlFileQueryMeta)queryMeta).getPath();
            if (sql.isEmpty() || StringUtil.isWhitespace((String)sql)) {
                throw new AptException((MessageResource)Message.DOMA4020, this.methodElement, new Object[]{path});
            }
            SqlNode sqlNode = this.createSqlNode(path, sql);
            SqlValidator validator = this.createSqlValidator((LinkedHashMap<String, TypeMirror>)((AbstractQueryMeta)queryMeta).getBindableParameterTypeMap(), path, expandable, populatable);
            validator.validate(sqlNode);
        }
    }

    private void processSqlFiles(M queryMeta, boolean expandable, boolean populatable) {
        String filePath = ((AbstractSqlFileQueryMeta)queryMeta).getPath();
        File file = this.getFile(filePath);
        File[] siblingFiles = this.getSiblingFiles(file);
        String dirPath = SqlFileUtil.buildPath((String)this.daoElement.getQualifiedName().toString());
        String methodName = ((AbstractQueryMeta)queryMeta).getName();
        for (File siblingFile : siblingFiles) {
            if (!SqlFileUtil.isSqlFile((File)siblingFile, (String)methodName)) continue;
            String fileName = siblingFile.getName();
            String sqlFilePath = dirPath + "/" + fileName;
            String sql = this.getSql(siblingFile, sqlFilePath);
            if (sql.isEmpty() || StringUtil.isWhitespace((String)sql)) {
                throw new AptException((MessageResource)Message.DOMA4020, this.methodElement, new Object[]{sqlFilePath});
            }
            SqlNode sqlNode = this.createSqlNode(sqlFilePath, sql);
            SqlValidator validator = this.createSqlValidator((LinkedHashMap<String, TypeMirror>)((AbstractQueryMeta)queryMeta).getBindableParameterTypeMap(), sqlFilePath, expandable, populatable);
            validator.validate(sqlNode);
            ((AbstractQueryMeta)queryMeta).addFileName(fileName);
        }
    }

    File getFile(String filePath) {
        File file;
        FileObject fileObject = this.getFileObject(filePath);
        URI uri = fileObject.toUri();
        if (!uri.isAbsolute()) {
            uri = new File(".").toURI().resolve(uri);
        }
        if (!(file = this.getCanonicalFile(new File(uri))).exists()) {
            throw new AptException((MessageResource)Message.DOMA4019, this.methodElement, new Object[]{filePath, file.getAbsolutePath()});
        }
        if (file.isDirectory()) {
            throw new AptException((MessageResource)Message.DOMA4021, this.methodElement, new Object[]{filePath, file.getAbsolutePath()});
        }
        if (!IOUtil.endsWith((File)file, (String)filePath)) {
            throw new AptException((MessageResource)Message.DOMA4309, this.methodElement, new Object[]{filePath, file.getAbsolutePath()});
        }
        return file;
    }

    private File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    File[] getSiblingFiles(File file) {
        File dir = this.getDir(file);
        File[] files = dir.listFiles();
        if (files == null) {
            throw new AptException((MessageResource)Message.DOMA4144, this.methodElement, new Object[]{dir.getAbsolutePath()});
        }
        return files;
    }

    private File getDir(File sqlFile) {
        File dir = sqlFile.getParentFile();
        if (dir == null) {
            AssertionUtil.assertUnreachable();
        }
        return dir;
    }

    private FileObject getFileObject(String path) {
        try {
            return this.ctx.getResources().getResource(path);
        }
        catch (IOException e) {
            throw new AptException((MessageResource)Message.DOMA4143, (Element)this.methodElement, e, new Object[]{path, e});
        }
    }

    private String getSql(File file, String filePath) {
        try {
            return IOUtil.readAsString((File)file);
        }
        catch (WrapException e) {
            Throwable cause = e.getCause();
            throw new AptException((MessageResource)Message.DOMA4068, (Element)this.methodElement, cause, new Object[]{filePath, cause});
        }
    }

    private SqlNode createSqlNode(String path, String sql) {
        try {
            SqlParser sqlParser = new SqlParser(sql);
            return sqlParser.parse();
        }
        catch (JdbcException e) {
            throw new AptException((MessageResource)Message.DOMA4069, (Element)this.methodElement, e, new Object[]{path, e});
        }
    }

    SqlValidator createSqlValidator(LinkedHashMap<String, TypeMirror> parameterTypeMap, String sqlFilePath, boolean expandable, boolean populatable) {
        return new SqlValidator(this.ctx, this.methodElement, parameterTypeMap, sqlFilePath, expandable, populatable);
    }
}

