/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.annot.SqlProcessorAnnot;
import org.seasar.doma.internal.apt.cttype.BiFunctionCtType;
import org.seasar.doma.internal.apt.cttype.ConfigCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.PreparedSqlCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.query.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.SqlProcessorQueryMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlProcessorQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlProcessorQueryMeta> {
    public SqlProcessorQueryMetaFactory(Context ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta() {
        SqlProcessorQueryMeta queryMeta = this.createSqlContentQueryMeta();
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        this.doSqlTemplate(queryMeta, false, false);
        return queryMeta;
    }

    private SqlProcessorQueryMeta createSqlContentQueryMeta() {
        SqlProcessorAnnot sqlProcessorAnnot = this.ctx.getAnnotations().newSqlProcessorAnnot(this.methodElement);
        if (sqlProcessorAnnot == null) {
            return null;
        }
        SqlProcessorQueryMeta queryMeta = new SqlProcessorQueryMeta(this.daoElement, this.methodElement);
        queryMeta.setSqlProcessorAnnot(sqlProcessorAnnot);
        queryMeta.setQueryKind(QueryKind.SQL_PROCESSOR);
        SqlAnnot sqlAnnot = this.ctx.getAnnotations().newSqlAnnot(this.methodElement);
        queryMeta.setSqlAnnot(sqlAnnot);
        return queryMeta;
    }

    @Override
    protected void doParameters(SqlProcessorQueryMeta queryMeta) {
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            parameterMeta.getCtType().accept(new ParamCtTypeVisitor(queryMeta, parameterMeta), null);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
        if (queryMeta.getBiFunctionCtType() == null) {
            SqlProcessorAnnot sqlProcessorAnnot = queryMeta.getSqlProcessorAnnot();
            throw new AptException((MessageResource)Message.DOMA4433, (Element)this.methodElement, sqlProcessorAnnot.getAnnotationMirror(), new Object[0]);
        }
    }

    @Override
    protected void doReturnType(SqlProcessorQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(returnMeta);
        BiFunctionCtType biFunctionCtType = queryMeta.getBiFunctionCtType();
        CtType resultCtType = biFunctionCtType.getResultCtType();
        if (!this.isConvertibleReturnType(returnMeta, resultCtType)) {
            throw new AptException((MessageResource)Message.DOMA4436, this.methodElement, new Object[]{returnMeta.getType(), resultCtType.getType()});
        }
    }

    private boolean isConvertibleReturnType(QueryReturnMeta returnMeta, CtType resultCtType) {
        if (this.ctx.getMoreTypes().isSameTypeWithErasure(returnMeta.getType(), resultCtType.getType())) {
            return true;
        }
        if (returnMeta.getType().getKind() == TypeKind.VOID) {
            return this.ctx.getMoreTypes().isSameTypeWithErasure(resultCtType.getType(), Void.class);
        }
        return false;
    }

    static class ParamBiFunctionSecondArgCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlProcessorQueryMeta queryMeta;
        final QueryParameterMeta parameterMeta;

        ParamBiFunctionSecondArgCtTypeVisitor(SqlProcessorQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4435, this.queryMeta.getMethodElement(), new Object[0]);
        }

        @Override
        public Void visitPreparedSqlCtType(PreparedSqlCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    static class ParamBiFunctionFirstArgCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlProcessorQueryMeta queryMeta;
        final QueryParameterMeta parameterMeta;

        ParamBiFunctionFirstArgCtTypeVisitor(SqlProcessorQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4437, this.queryMeta.getMethodElement(), new Object[0]);
        }

        @Override
        public Void visitConfigCtType(ConfigCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    static class ParamCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlProcessorQueryMeta queryMeta;
        final QueryParameterMeta parameterMeta;

        ParamCtTypeVisitor(SqlProcessorQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        public Void visitBiFunctionCtType(BiFunctionCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getBiFunctionCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4434, this.parameterMeta.getElement(), new Object[0]);
            }
            ctType.getFirstArgCtType().accept(new ParamBiFunctionFirstArgCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            ctType.getSecondArgCtType().accept(new ParamBiFunctionSecondArgCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            this.queryMeta.setBiFunctionCtType(ctType);
            this.queryMeta.setBiFunctionParameterName(this.parameterMeta.getName());
            return null;
        }
    }
}

