/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Embeddable;
import org.seasar.doma.EntityField;
import org.seasar.doma.GeneratedValue;
import org.seasar.doma.Id;
import org.seasar.doma.OriginalStates;
import org.seasar.doma.ParameterName;
import org.seasar.doma.TenantId;
import org.seasar.doma.Transient;
import org.seasar.doma.Version;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.AllArgsConstructorAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddableAnnot;
import org.seasar.doma.internal.apt.annot.ValueAnnot;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableConstructorMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMetaFactory;
import org.seasar.doma.internal.apt.util.ElementKindUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EmbeddableMetaFactory
implements TypeElementMetaFactory<EmbeddableMeta> {
    private final Context ctx;

    public EmbeddableMetaFactory(Context ctx) {
        AssertionUtil.assertNotNull((Object)ctx);
        this.ctx = ctx;
    }

    @Override
    public EmbeddableMeta createTypeElementMeta(TypeElement embeddableElement) {
        EmbeddableAnnot mirror = this.ctx.getAnnotations().newEmbeddableAnnot(embeddableElement);
        if (mirror == null) {
            throw new AptIllegalStateException("annot must not be null");
        }
        EmbeddableMeta embeddableMeta = new EmbeddableMeta(mirror, embeddableElement);
        Strategy strategy = this.createStrategy(embeddableElement, embeddableMeta);
        strategy.validateClass(embeddableElement, embeddableMeta);
        strategy.doFieldElements(embeddableElement, embeddableMeta);
        strategy.doConstructor(embeddableElement, embeddableMeta);
        return embeddableMeta;
    }

    private Strategy createStrategy(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
        ValueAnnot valueAnnot = this.ctx.getAnnotations().newValueAnnot(embeddableElement);
        if (valueAnnot != null) {
            return new ValueStrategy(this.ctx, valueAnnot);
        }
        AllArgsConstructorAnnot allArgsConstructorAnnot = this.ctx.getAnnotations().newAllArgsConstructorAnnot(embeddableElement);
        if (allArgsConstructorAnnot != null) {
            return new AllArgsConstructorStrategy(this.ctx, allArgsConstructorAnnot);
        }
        return new DefaultStrategy(this.ctx);
    }

    protected static class ValueStrategy
    extends DefaultStrategy {
        final ValueAnnot valueAnnot;

        ValueStrategy(Context ctx, ValueAnnot valueAnnot) {
            super(ctx);
            AssertionUtil.assertNotNull((Object)valueAnnot);
            this.valueAnnot = valueAnnot;
        }

        @Override
        public void doConstructor(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            if (!this.valueAnnot.getStaticConstructorValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4423, embeddableElement, this.valueAnnot.getAnnotationMirror(), this.valueAnnot.getStaticConstructor(), new Object[]{embeddableElement.getQualifiedName()});
            }
        }
    }

    protected static class AllArgsConstructorStrategy
    extends DefaultStrategy {
        final AllArgsConstructorAnnot allArgsConstructorAnnot;

        AllArgsConstructorStrategy(Context ctx, AllArgsConstructorAnnot allArgsConstructorAnnot) {
            super(ctx);
            AssertionUtil.assertNotNull((Object)allArgsConstructorAnnot);
            this.allArgsConstructorAnnot = allArgsConstructorAnnot;
        }

        @Override
        public void doConstructor(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            if (!this.allArgsConstructorAnnot.getStaticNameValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4424, embeddableElement, this.allArgsConstructorAnnot.getAnnotationMirror(), this.allArgsConstructorAnnot.getStaticName(), new Object[0]);
            }
            if (this.allArgsConstructorAnnot.isAccessPrivate()) {
                throw new AptException((MessageResource)Message.DOMA4425, embeddableElement, this.allArgsConstructorAnnot.getAnnotationMirror(), this.allArgsConstructorAnnot.getAccess(), new Object[0]);
            }
            if (this.allArgsConstructorAnnot.isAccessNone()) {
                throw new AptException((MessageResource)Message.DOMA4427, embeddableElement, this.allArgsConstructorAnnot.getAnnotationMirror(), this.allArgsConstructorAnnot.getAccess(), new Object[0]);
            }
        }
    }

    protected static class DefaultStrategy
    implements Strategy {
        final Context ctx;

        DefaultStrategy(Context ctx) {
            AssertionUtil.assertNotNull((Object)ctx);
            this.ctx = ctx;
        }

        @Override
        public void validateClass(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            ElementKind kind = embeddableElement.getKind();
            if (kind != ElementKind.CLASS && !ElementKindUtil.isRecord(kind)) {
                EmbeddableAnnot embeddableAnnot = embeddableMeta.getEmbeddableAnnot();
                throw new AptException((MessageResource)Message.DOMA4283, (Element)embeddableElement, embeddableAnnot.getAnnotationMirror(), new Object[0]);
            }
            if (!embeddableElement.getTypeParameters().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4285, embeddableElement, new Object[0]);
            }
            this.validateEnclosingElement(embeddableElement);
        }

        void validateEnclosingElement(Element element) {
            TypeElement typeElement = this.ctx.getMoreElements().toTypeElement(element);
            if (typeElement == null) {
                return;
            }
            String simpleName = typeElement.getSimpleName().toString();
            if (simpleName.contains("$") || simpleName.contains("__")) {
                throw new AptException((MessageResource)Message.DOMA4417, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.TOP_LEVEL) {
                return;
            }
            if (nestingKind == NestingKind.MEMBER) {
                Set<Modifier> modifiers = typeElement.getModifiers();
                if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                    throw new AptException((MessageResource)Message.DOMA4415, typeElement, new Object[]{typeElement.getQualifiedName()});
                }
            } else {
                throw new AptException((MessageResource)Message.DOMA4416, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            this.validateEnclosingElement(typeElement.getEnclosingElement());
        }

        @Override
        public void doFieldElements(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            for (VariableElement fieldElement : this.getFieldElements(embeddableElement)) {
                try {
                    if (fieldElement.getAnnotation(Transient.class) != null || fieldElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    if (fieldElement.getAnnotation(OriginalStates.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4286, fieldElement, new Object[0]);
                    }
                    if (fieldElement.getAnnotation(Id.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4289, fieldElement, new Object[0]);
                    }
                    if (fieldElement.getAnnotation(Version.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4290, fieldElement, new Object[0]);
                    }
                    if (fieldElement.getAnnotation(TenantId.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4443, fieldElement, new Object[0]);
                    }
                    if (fieldElement.getAnnotation(GeneratedValue.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4291, fieldElement, new Object[0]);
                    }
                    this.doEmbeddablePropertyMeta(fieldElement, embeddableMeta);
                }
                catch (AptException e) {
                    this.ctx.getReporter().report(e);
                    embeddableMeta.setError(true);
                }
            }
        }

        void doEmbeddablePropertyMeta(VariableElement fieldElement, EmbeddableMeta embeddableMeta) {
            this.validateFieldAnnotation(fieldElement, embeddableMeta);
            EmbeddablePropertyMetaFactory propertyMetaFactory = new EmbeddablePropertyMetaFactory(this.ctx, fieldElement);
            EmbeddablePropertyMeta propertyMeta = propertyMetaFactory.createEmbeddablePropertyMeta();
            embeddableMeta.addEmbeddablePropertyMeta(propertyMeta);
        }

        List<VariableElement> getFieldElements(TypeElement embeddableElement) {
            LinkedList<VariableElement> results = new LinkedList<VariableElement>();
            TypeElement t = embeddableElement;
            while (t != null && t.asType().getKind() != TypeKind.NONE) {
                if (t.getAnnotation(Embeddable.class) != null) {
                    LinkedList<VariableElement> fields = new LinkedList<VariableElement>(ElementFilter.fieldsIn(t.getEnclosedElements()));
                    Collections.reverse(fields);
                    results.addAll(fields);
                }
                t = this.ctx.getMoreTypes().toTypeElement(t.getSuperclass());
            }
            Collections.reverse(results);
            LinkedList hiderFields = new LinkedList(results);
            Iterator it = results.iterator();
            while (it.hasNext()) {
                VariableElement hidden = (VariableElement)it.next();
                for (VariableElement hider : hiderFields) {
                    if (!this.ctx.getMoreElements().hides(hider, hidden)) continue;
                    it.remove();
                }
            }
            return results;
        }

        void validateFieldAnnotation(VariableElement fieldElement, EmbeddableMeta embeddableMeta) {
            TypeElement foundAnnotationTypeElement = null;
            for (AnnotationMirror annotationMirror : fieldElement.getAnnotationMirrors()) {
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(declaredType);
                if (typeElement.getAnnotation(EntityField.class) == null) continue;
                if (foundAnnotationTypeElement != null) {
                    throw new AptException((MessageResource)Message.DOMA4288, fieldElement, new Object[]{foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName()});
                }
                foundAnnotationTypeElement = typeElement;
            }
        }

        @Override
        public void doConstructor(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            if (embeddableMeta.isAbstract()) {
                return;
            }
            EmbeddableConstructorMeta constructorMeta = this.getConstructorMeta(embeddableElement, embeddableMeta);
            if (constructorMeta == null) {
                throw new AptException((MessageResource)Message.DOMA4293, embeddableElement, new Object[0]);
            }
            if (constructorMeta.getConstructorElement().getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new AptException((MessageResource)Message.DOMA4294, embeddableElement, new Object[0]);
            }
            embeddableMeta.setConstructorMeta(constructorMeta);
        }

        EmbeddableConstructorMeta getConstructorMeta(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            HashMap<String, EmbeddablePropertyMeta> propertyMetaMap = new HashMap<String, EmbeddablePropertyMeta>();
            for (EmbeddablePropertyMeta propertyMeta : embeddableMeta.getEmbeddablePropertyMetas()) {
                propertyMetaMap.put(propertyMeta.getName(), propertyMeta);
            }
            block1: for (ExecutableElement constructor : ElementFilter.constructorsIn(embeddableElement.getEnclosedElements())) {
                ArrayList<EmbeddablePropertyMeta> propertyMetaList = new ArrayList<EmbeddablePropertyMeta>();
                for (VariableElement variableElement : constructor.getParameters()) {
                    String name = variableElement.getSimpleName().toString();
                    ParameterName parameterName = variableElement.getAnnotation(ParameterName.class);
                    if (parameterName != null) {
                        name = parameterName.value();
                    }
                    TypeMirror paramType = variableElement.asType();
                    EmbeddablePropertyMeta propertyMeta = (EmbeddablePropertyMeta)propertyMetaMap.get(name);
                    if (propertyMeta == null) continue block1;
                    TypeMirror propertyType = propertyMeta.getType();
                    if (!this.ctx.getMoreTypes().isSameTypeWithErasure(paramType, propertyType)) continue block1;
                    propertyMetaList.add(propertyMeta);
                }
                if (propertyMetaMap.size() != propertyMetaList.size()) continue;
                return new EmbeddableConstructorMeta(constructor, propertyMetaList);
            }
            return null;
        }
    }

    static interface Strategy {
        public void validateClass(TypeElement var1, EmbeddableMeta var2);

        public void doFieldElements(TypeElement var1, EmbeddableMeta var2);

        public void doConstructor(TypeElement var1, EmbeddableMeta var2);
    }
}

