/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.EntityTypeImplementation;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.EntityTypePropertyGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.id.IdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.id.IdGeneratorMetaVisitor;
import org.seasar.doma.internal.apt.meta.id.IdentityIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.id.SequenceIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.id.TableIdGeneratorMeta;
import org.seasar.doma.internal.jdbc.entity.NullEntityListenerSuppliers;
import org.seasar.doma.internal.jdbc.entity.TableNames;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.AbstractEntityType;
import org.seasar.doma.jdbc.entity.EmbeddedPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.OriginalStatesAccessor;
import org.seasar.doma.jdbc.entity.PostDeleteContext;
import org.seasar.doma.jdbc.entity.PostInsertContext;
import org.seasar.doma.jdbc.entity.PostUpdateContext;
import org.seasar.doma.jdbc.entity.PreDeleteContext;
import org.seasar.doma.jdbc.entity.PreInsertContext;
import org.seasar.doma.jdbc.entity.PreUpdateContext;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.entity.TenantIdPropertyType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class EntityTypeGenerator
extends AbstractGenerator {
    private final EntityMeta entityMeta;

    public EntityTypeGenerator(Context ctx, ClassName className, Printer printer, EntityMeta entityMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)entityMeta);
        this.entityMeta = entityMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.printEntityTypeImplementation();
        this.iprint("public final class %1$s extends %2$s<%3$s> {%n", this.simpleName, AbstractEntityType.class, this.entityMeta.getType());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructor();
        this.printMethods();
        this.printListenerHolder();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printEntityTypeImplementation() {
        this.iprint("@%1$s%n", EntityTypeImplementation.class);
    }

    private void printFields() {
        this.printSingletonField();
        this.printOriginalStatesAccessorField();
        this.printNamingTypeField();
        this.printIdGeneratorField();
        this.printListenerSupplierField();
        this.printImmutableField();
        this.printCatalogNameField();
        this.printSchemaNameField();
        this.printTableNameField();
        this.printIsQuoteRequiredField();
        this.printNameField();
        this.printIdPropertyTypesField();
        this.printEntityPropertyTypesField();
        this.printEntityPropertyTypeMapField();
        this.printEmbeddedPropertyTypeMapField();
    }

    private void printSingletonField() {
        this.iprint("private static final %1$s __singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    private void printOriginalStatesAccessorField() {
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            OriginalStatesMeta osm = this.entityMeta.getOriginalStatesMeta();
            this.iprint("private static final %1$s<%2$s> __originalStatesAccessor = new %1$s<>(%3$s.class, \"%4$s\");%n", OriginalStatesAccessor.class, osm.getTypeElement(), osm.getFieldEnclosingElement(), osm.getFieldElement());
            this.print("%n", new Object[0]);
        }
    }

    private void printIdGeneratorField() {
        if (this.entityMeta.hasGeneratedIdPropertyMeta()) {
            EntityPropertyMeta propertyMeta = this.entityMeta.getGeneratedIdPropertyMeta();
            IdGeneratorMeta idGeneratorMeta = propertyMeta.getIdGeneratorMeta();
            idGeneratorMeta.accept(new IdGeneratorGenerator(), null);
            this.print("%n", new Object[0]);
        }
    }

    private void printListenerSupplierField() {
        if (this.entityMeta.isGenericEntityListener()) {
            this.iprint("private final java.util.function.Supplier<%1$s<%2$s>> __listenerSupplier;%n", this.entityMeta.getEntityListenerElement(), this.entityMeta.getType());
        } else {
            this.iprint("private final java.util.function.Supplier<%1$s> __listenerSupplier;%n", this.entityMeta.getEntityListenerElement());
        }
        this.print("%n", new Object[0]);
    }

    private void printNamingTypeField() {
        NamingType namingType = this.entityMeta.getNamingType();
        if (namingType == null) {
            this.iprint("private final %1$s __namingType = null;%n", NamingType.class);
        } else {
            this.iprint("private final %1$s __namingType = %1$s.%2$s;%n", NamingType.class, namingType.name());
        }
        this.print("%n", new Object[0]);
    }

    private void printImmutableField() {
        this.iprint("private final boolean __immutable;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printCatalogNameField() {
        this.iprint("private final String __catalogName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printSchemaNameField() {
        this.iprint("private final String __schemaName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printTableNameField() {
        this.iprint("private final String __tableName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printIsQuoteRequiredField() {
        this.iprint("private final boolean __isQuoteRequired;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printNameField() {
        this.iprint("private final String __name;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printIdPropertyTypesField() {
        this.iprint("private final java.util.List<%1$s<%2$s, ?>> __idPropertyTypes;%n", EntityPropertyType.class, this.entityMeta.getType());
        this.print("%n", new Object[0]);
    }

    private void printEntityPropertyTypesField() {
        this.iprint("private final java.util.List<%1$s<%2$s, ?>> __entityPropertyTypes;%n", EntityPropertyType.class, this.entityMeta.getType());
        this.print("%n", new Object[0]);
    }

    private void printEntityPropertyTypeMapField() {
        this.iprint("private final java.util.Map<String, %1$s<%2$s, ?>> __entityPropertyTypeMap;%n", EntityPropertyType.class, this.entityMeta.getType());
        this.print("%n", new Object[0]);
    }

    private void printEmbeddedPropertyTypeMapField() {
        if (!this.entityMeta.hasEmbeddedProperties()) {
            this.iprint("@SuppressWarnings(\"unused\")%n", new Object[0]);
        }
        this.iprint("private final java.util.Map<String, %1$s<%2$s, ?>> __embeddedPropertyTypeMap;%n", EmbeddedPropertyType.class, this.entityMeta.getType());
        this.print("%n", new Object[0]);
    }

    private void printConstructor() {
        this.iprint("private %1$s() {%n", this.simpleName);
        if (this.entityMeta.isNullEntityListener()) {
            this.iprint("    __listenerSupplier = %1$s.of();%n", NullEntityListenerSuppliers.class);
        } else if (this.entityMeta.isGenericEntityListener()) {
            this.iprint("    __listenerSupplier = new java.util.function.Supplier<%1$s<%2$s>>() { @Override public %1$s<%2$s> get() { return ListenerHolder.listener; } };%n", this.entityMeta.getEntityListenerElement(), this.entityMeta.getType());
        } else {
            this.iprint("    __listenerSupplier = new java.util.function.Supplier<%1$s>() { @Override public %1$s get() { return ListenerHolder.listener; } };%n", this.entityMeta.getEntityListenerElement());
        }
        this.iprint("    __immutable = %1$s;%n", this.entityMeta.isImmutable());
        this.iprint("    __name = \"%1$s\";%n", this.entityMeta.getEntityName());
        this.iprint("    __catalogName = \"%1$s\";%n", this.entityMeta.getCatalogName());
        this.iprint("    __schemaName = \"%1$s\";%n", this.entityMeta.getSchemaName());
        this.iprint("    __tableName = \"%1$s\";%n", this.entityMeta.getTableName());
        this.iprint("    __isQuoteRequired = %1$s;%n", this.entityMeta.isQuoteRequired());
        this.iprint("    java.util.List<%1$s<%2$s, ?>> __idList = new java.util.ArrayList<>();%n", EntityPropertyType.class, this.entityMeta.getType());
        this.iprint("    java.util.List<%1$s<%2$s, ?>> __list = new java.util.ArrayList<>(%3$s);%n", EntityPropertyType.class, this.entityMeta.getType(), this.entityMeta.getAllPropertyMetas().size());
        this.iprint("    java.util.Map<String, %1$s<%2$s, ?>> __map = new java.util.LinkedHashMap<>(%3$s);%n", EntityPropertyType.class, this.entityMeta.getType(), this.entityMeta.getAllPropertyMetas().size());
        this.iprint("    java.util.Map<String, %1$s<%2$s, ?>> __embeddedMap = new java.util.LinkedHashMap<>(%3$s);%n", EmbeddedPropertyType.class, this.entityMeta.getType(), this.entityMeta.getAllPropertyMetas().size());
        this.iprint("    initializeMaps(__map, __embeddedMap);%n", new Object[0]);
        this.iprint("    initializeIdList(__map, __idList);%n", new Object[0]);
        this.iprint("    initializeList(__map, __list);%n", new Object[0]);
        this.iprint("    __idPropertyTypes = java.util.Collections.unmodifiableList(__idList);%n", new Object[0]);
        this.iprint("    __entityPropertyTypes = java.util.Collections.unmodifiableList(__list);%n", new Object[0]);
        this.iprint("    __entityPropertyTypeMap = java.util.Collections.unmodifiableMap(__map);%n", new Object[0]);
        this.iprint("    __embeddedPropertyTypeMap = java.util.Collections.unmodifiableMap(__embeddedMap);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        this.printInitializeMapsMethod();
        this.printInitializeIdListMethod();
        this.printInitializeListMethod();
        this.printGetNamingTypeMethod();
        this.printIsImmutableMethod();
        this.printGetNameMethod();
        this.printGetCatalogNameMethod();
        this.printGetSchemaNameMethod();
        this.printGetTableNameMethod();
        this.printIsQuoteRequiredMethod();
        this.printPreInsertMethod();
        this.printPreUpdateMethod();
        this.printPreDeleteMethod();
        this.printPostInsertMethod();
        this.printPostUpdateMethod();
        this.printPostDeleteMethod();
        this.printGetEntityPropertyTypesMethod();
        this.printGetEntityPropertyTypeMethod();
        this.printGetIdPropertyTypesMethod();
        this.printGetGeneratedIdPropertyTypeMethod();
        this.printGetVersionPropertyTypeMethod();
        this.printGetTenantIdPropertyTypeMethod();
        this.printNewEntityMethod();
        this.printGetEntityClassMethod();
        this.printGetOriginalStatesMethod();
        this.printSaveCurrentStatesMethod();
        this.printGetSingletonInternalMethod();
        this.printNewInstanceMethod();
    }

    private void printInitializeMapsMethod() {
        this.iprint("private void initializeMaps(java.util.Map<String, %1$s<%2$s, ?>> __map, java.util.Map<String, %3$s<%2$s, ?>> __embeddedMap) {%n", EntityPropertyType.class, this.entityMeta.getType(), EmbeddedPropertyType.class);
        this.indent();
        for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
            EntityTypePropertyGenerator propertyGenerator = new EntityTypePropertyGenerator(this.ctx, this.className, this.printer, this.entityMeta, pm);
            if (pm.isEmbedded()) {
                this.iprint("__embeddedMap.put(\"%1$s\", ", pm.getName());
                propertyGenerator.generate();
                this.print(");%n", new Object[0]);
                this.iprint("__map.putAll(__embeddedMap.get(\"%1$s\").getEmbeddablePropertyTypeMap());%n", pm.getName());
                continue;
            }
            this.iprint("__map.put(\"%1$s\", ", pm.getName());
            propertyGenerator.generate();
            this.print(");%n", new Object[0]);
        }
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printInitializeIdListMethod() {
        this.iprint("private void initializeIdList(java.util.Map<String, %1$s<%2$s, ?>> __map, java.util.List<%1$s<%2$s, ?>> __idList) {%n", EntityPropertyType.class, this.entityMeta.getType());
        this.indent();
        for (EntityPropertyMeta pm : this.entityMeta.getIdPropertyMetas()) {
            this.iprint("__idList.add(__map.get(\"%1$s\"));%n", pm.getName());
        }
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printInitializeListMethod() {
        this.iprint("private void initializeList(java.util.Map<String, %1$s<%2$s, ?>> __map, java.util.List<%1$s<%2$s, ?>> __list) {%n", EntityPropertyType.class, this.entityMeta.getType());
        this.indent();
        this.iprint("__list.addAll(__map.values());%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetNamingTypeMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s getNamingType() {%n", NamingType.class);
        this.iprint("    return __namingType;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printIsImmutableMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public boolean isImmutable() {%n", new Object[0]);
        this.iprint("    return __immutable;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getName() {%n", new Object[0]);
        this.iprint("    return __name;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetCatalogNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getCatalogName() {%n", new Object[0]);
        this.iprint("    return __catalogName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetSchemaNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getSchemaName() {%n", new Object[0]);
        this.iprint("    return __schemaName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetTableNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("@Deprecated%n", new Object[0]);
        this.iprint("public String getTableName() {%n", new Object[0]);
        this.iprint("    return getTableName(%1$s.namingFunction);%n", TableNames.class);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getTableName(%1$s<%2$s, String, String> namingFunction) {%n", BiFunction.class, NamingType.class);
        this.iprint("    if (__tableName.isEmpty()) {%n", new Object[0]);
        this.iprint("        return namingFunction.apply(__namingType, __name);%n", new Object[0]);
        this.iprint("    }%n", new Object[0]);
        this.iprint("    return __tableName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printIsQuoteRequiredMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public boolean isQuoteRequired() {%n", new Object[0]);
        this.iprint("    return __isQuoteRequired;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printPreInsertMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preInsert(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getType(), PreInsertContext.class);
        this.printDeclareListener();
        this.iprint("    __listener.preInsert(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printPreUpdateMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preUpdate(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getType(), PreUpdateContext.class);
        this.printDeclareListener();
        this.iprint("    __listener.preUpdate(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printPreDeleteMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preDelete(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getType(), PreDeleteContext.class);
        this.printDeclareListener();
        this.iprint("    __listener.preDelete(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printPostInsertMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postInsert(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getType(), PostInsertContext.class);
        this.printDeclareListener();
        this.iprint("    __listener.postInsert(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printPostUpdateMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postUpdate(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getType(), PostUpdateContext.class);
        this.printDeclareListener();
        this.iprint("    __listener.postUpdate(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printPostDeleteMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postDelete(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getType(), PostDeleteContext.class);
        this.printDeclareListener();
        this.iprint("    __listener.postDelete(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetEntityPropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public java.util.List<%1$s<%2$s, ?>> getEntityPropertyTypes() {%n", EntityPropertyType.class, this.entityMeta.getType());
        this.iprint("    return __entityPropertyTypes;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetEntityPropertyTypeMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, ?> getEntityPropertyType(String __name) {%n", EntityPropertyType.class, this.entityMeta.getType());
        this.iprint("    return __entityPropertyTypeMap.get(__name);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetIdPropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public java.util.List<%1$s<%2$s, ?>> getIdPropertyTypes() {%n", EntityPropertyType.class, this.entityMeta.getType());
        this.iprint("    return __idPropertyTypes;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetGeneratedIdPropertyTypeMethod() {
        String idName = "null";
        if (this.entityMeta.hasGeneratedIdPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getGeneratedIdPropertyMeta();
            idName = pm.getName();
        }
        this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, ?, ?> getGeneratedIdPropertyType() {%n", GeneratedIdPropertyType.class, this.entityMeta.getType());
        this.iprint("    return (%1$s<%2$s, ?, ?>)__entityPropertyTypeMap.get(\"%3$s\");%n", GeneratedIdPropertyType.class, this.entityMeta.getType(), idName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetVersionPropertyTypeMethod() {
        String versionName = "null";
        if (this.entityMeta.hasVersionPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getVersionPropertyMeta();
            versionName = pm.getName();
        }
        this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, ?, ?> getVersionPropertyType() {%n", VersionPropertyType.class, this.entityMeta.getType());
        this.iprint("    return (%1$s<%2$s, ?, ?>)__entityPropertyTypeMap.get(\"%3$s\");%n", VersionPropertyType.class, this.entityMeta.getType(), versionName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetTenantIdPropertyTypeMethod() {
        String tenantIdName = "null";
        if (this.entityMeta.hasTenantIdPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getTenantIdPropertyMeta();
            tenantIdName = pm.getName();
        }
        this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, ?, ?> getTenantIdPropertyType() {%n", TenantIdPropertyType.class, this.entityMeta.getType());
        this.iprint("    return (%1$s<%2$s, ?, ?>)__entityPropertyTypeMap.get(\"%3$s\");%n", TenantIdPropertyType.class, this.entityMeta.getType(), tenantIdName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printNewEntityMethod() {
        if (this.hasGenericTypeProperty() || !this.entityMeta.isImmutable() && this.entityMeta.hasEmbeddedProperties()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s newEntity(%2$s<String, %3$s<%1$s, ?>> __args) {%n", this.entityMeta.getType(), Map.class, Property.class);
        if (this.entityMeta.isAbstract()) {
            this.iprint("    return null;%n", new Object[0]);
        } else if (this.entityMeta.isImmutable()) {
            this.iprint("    return new %1$s(%n", this.entityMeta.getType());
            Iterator<EntityPropertyMeta> it = this.entityMeta.getAllPropertyMetas().iterator();
            while (it.hasNext()) {
                final EntityPropertyMeta propertyMeta = it.next();
                propertyMeta.getCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                    @Override
                    public Void visitEmbeddableCtType(EmbeddableCtType ctType, Void aVoid) throws RuntimeException {
                        EntityTypeGenerator.this.iprint("        %1$s.newEmbeddable(\"%2$s\", __args)", ctType.getTypeCode(), propertyMeta.getName());
                        return null;
                    }

                    @Override
                    protected Void defaultAction(CtType ctType, Void aVoid) throws RuntimeException {
                        EntityTypeGenerator.this.iprint("        (%1$s)(__args.get(\"%2$s\") != null ? __args.get(\"%2$s\").get() : null)", propertyMeta.getBoxedType(), propertyMeta.getName());
                        return null;
                    }
                }, null);
                if (!it.hasNext()) continue;
                this.print(",%n", new Object[0]);
            }
            this.print(");%n", new Object[0]);
        } else {
            this.iprint("    %1$s entity = new %1$s();%n", this.entityMeta.getType());
            for (final EntityPropertyMeta propertyMeta : this.entityMeta.getAllPropertyMetas()) {
                propertyMeta.getCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                    @Override
                    public Void visitEmbeddableCtType(EmbeddableCtType ctType, Void aVoid) throws RuntimeException {
                        EntityTypeGenerator.this.iprint("    ((%4$s<%5$s, %6$s>)__embeddedPropertyTypeMap.get(\"%1$s\")).save(entity, %2$s.newEmbeddable(\"%3$s\", __args));%n", propertyMeta.getName(), ctType.getTypeCode(), propertyMeta.getName(), EmbeddedPropertyType.class, EntityTypeGenerator.this.entityMeta.getType(), ctType.getType());
                        return null;
                    }

                    @Override
                    protected Void defaultAction(CtType ctType, Void aVoid) throws RuntimeException {
                        EntityTypeGenerator.this.iprint("    if (__args.get(\"%1$s\") != null) __args.get(\"%1$s\").save(entity);%n", propertyMeta.getName());
                        return null;
                    }
                }, null);
            }
            this.iprint("    return entity;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private boolean hasGenericTypeProperty() {
        if (this.entityMeta.isImmutable()) {
            for (EntityPropertyMeta propertyMeta : this.entityMeta.getAllPropertyMetas()) {
                TypeElement element = this.ctx.getMoreTypes().toTypeElement(propertyMeta.getType());
                if (element == null || element.getTypeParameters().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void printGetEntityClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getEntityClass() {%n", this.entityMeta.getType());
        this.iprint("    return %1$s.class;%n", this.entityMeta.getType());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetOriginalStatesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s getOriginalStates(%1$s __entity) {%n", this.entityMeta.getType());
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            this.iprint("    return __originalStatesAccessor.get(__entity);%n", new Object[0]);
        } else {
            this.iprint("    return null;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printSaveCurrentStatesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void saveCurrentStates(%1$s __entity) {%n", this.entityMeta.getType());
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            this.iprint("    %1$s __currentStates = new %1$s();%n", this.entityMeta.getType());
            for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
                this.iprint("    (__entityPropertyTypeMap.get(\"%1$s\")).copy(__currentStates, __entity);%n", pm.getName());
            }
            this.iprint("    __originalStatesAccessor.set(__entity, __currentStates);%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
        this.iprint("    return __singleton;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printNewInstanceMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the new instance%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s newInstance() {%n", this.simpleName);
        this.iprint("    return new %1$s();%n", this.simpleName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printListenerHolder() {
        if (this.entityMeta.isNullEntityListener()) {
            return;
        }
        this.iprint("private static class ListenerHolder {%n", new Object[0]);
        if (this.entityMeta.isGenericEntityListener()) {
            this.iprint("    private static %1$s<%2$s> listener = new %1$s<>();%n", this.entityMeta.getEntityListenerElement(), this.entityMeta.getType());
        } else {
            this.iprint("    private static %1$s listener = new %1$s();%n", this.entityMeta.getEntityListenerElement());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printDeclareListener() {
        this.iprint("    Class __listenerClass = %1$s.class;%n", this.entityMeta.getEntityListenerElement());
        this.iprint("    %1$s __listener = context.getConfig().getEntityListenerProvider().get(__listenerClass, __listenerSupplier);%n", this.entityMeta.getEntityListenerElement());
    }

    protected class IdGeneratorGenerator
    implements IdGeneratorMetaVisitor<Void, Void> {
        protected IdGeneratorGenerator() {
        }

        @Override
        public Void visitIdentityIdGeneratorMeta(IdentityIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            return null;
        }

        @Override
        public Void visitSequenceIdGeneratorMeta(SequenceIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            EntityTypeGenerator.this.iprint("{%n", new Object[0]);
            EntityTypeGenerator.this.iprint("    __idGenerator.setQualifiedSequenceName(\"%1$s\");%n", m.getQualifiedSequenceName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setInitialValue(%1$s);%n", m.getInitialValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setAllocationSize(%1$s);%n", m.getAllocationSize());
            EntityTypeGenerator.this.iprint("    __idGenerator.initialize();%n", new Object[0]);
            EntityTypeGenerator.this.iprint("}%n", new Object[0]);
            return null;
        }

        @Override
        public Void visitTableIdGeneratorMeta(TableIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            EntityTypeGenerator.this.iprint("{%n", new Object[0]);
            EntityTypeGenerator.this.iprint("    __idGenerator.setQualifiedTableName(\"%1$s\");%n", m.getQualifiedTableName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setInitialValue(%1$s);%n", m.getInitialValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setAllocationSize(%1$s);%n", m.getAllocationSize());
            EntityTypeGenerator.this.iprint("    __idGenerator.setPkColumnName(\"%1$s\");%n", m.getPkColumnName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setPkColumnValue(\"%1$s\");%n", m.getPkColumnValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setValueColumnName(\"%1$s\");%n", m.getValueColumnName());
            EntityTypeGenerator.this.iprint("    __idGenerator.initialize();%n", new Object[0]);
            EntityTypeGenerator.this.iprint("}%n", new Object[0]);
            return null;
        }
    }
}

