/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.FunctionAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.parameter.BasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.EntityResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.MapResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.ResultParameterMeta;
import org.seasar.doma.internal.apt.meta.query.AutoFunctionQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoModuleQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoFunctionQueryMetaFactory
extends AutoModuleQueryMetaFactory<AutoFunctionQueryMeta> {
    public AutoFunctionQueryMetaFactory(Context ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta() {
        FunctionAnnot functionAnnot = this.ctx.getAnnotations().newFunctionAnnot(this.methodElement);
        if (functionAnnot == null) {
            return null;
        }
        AutoFunctionQueryMeta queryMeta = new AutoFunctionQueryMeta(this.daoElement, this.methodElement);
        queryMeta.setFunctionAnnot(functionAnnot);
        queryMeta.setQueryKind(QueryKind.AUTO_FUNCTION);
        this.doTypeParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doParameters(queryMeta);
        this.doThrowTypes(queryMeta);
        return queryMeta;
    }

    @Override
    protected void doReturnType(AutoFunctionQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(returnMeta);
        ResultParameterMeta resultParameterMeta = this.createResultParameterMeta(queryMeta, returnMeta);
        queryMeta.setResultParameterMeta(resultParameterMeta);
    }

    private ResultParameterMeta createResultParameterMeta(AutoFunctionQueryMeta queryMeta, QueryReturnMeta returnMeta) {
        return returnMeta.getCtType().accept(new ReturnCtTypeVisitor(queryMeta, returnMeta), false);
    }

    class IterableElementCtTypeVisitor
    extends SimpleCtTypeVisitor<ResultParameterMeta, Boolean, RuntimeException> {
        final AutoFunctionQueryMeta queryMeta;
        final QueryReturnMeta returnMeta;

        IterableElementCtTypeVisitor(AutoFunctionQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected ResultParameterMeta defaultAction(CtType ctType, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4065, AutoFunctionQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
        }

        @Override
        public ResultParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicResultListParameterMeta(ctType);
            }
            return new BasicResultListParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainResultListParameterMeta(ctType);
            }
            return new DomainResultListParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitEntityCtType(EntityCtType ctType, Boolean p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4156, AutoFunctionQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
            }
            return new EntityResultListParameterMeta(ctType, this.queryMeta.getEnsureResultMapping());
        }

        @Override
        public ResultParameterMeta visitMapCtType(MapCtType ctType, Boolean p) throws RuntimeException {
            return new MapResultListParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public ResultParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntResultListParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongResultListParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleResultListParameterMeta();
        }
    }

    class ReturnCtTypeVisitor
    extends SimpleCtTypeVisitor<ResultParameterMeta, Boolean, RuntimeException> {
        final AutoFunctionQueryMeta queryMeta;
        final QueryReturnMeta returnMeta;

        ReturnCtTypeVisitor(AutoFunctionQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected ResultParameterMeta defaultAction(CtType ctType, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4063, AutoFunctionQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
        }

        @Override
        public ResultParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicSingleResultParameterMeta(ctType);
            }
            return new BasicSingleResultParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainSingleResultParameterMeta(ctType);
            }
            return new DomainSingleResultParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitIterableCtType(IterableCtType ctType, Boolean p) throws RuntimeException {
            if (!ctType.isList()) {
                this.defaultAction((CtType)ctType, p);
            }
            return ctType.getElementCtType().accept(new IterableElementCtTypeVisitor(this.queryMeta, this.returnMeta), false);
        }

        @Override
        public ResultParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public ResultParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntSingleResultParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongSingleResultParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleSingleResultParameterMeta();
        }
    }
}

