/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Embeddable;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.generator.EmbeddableTypeGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMetaFactory;
import org.seasar.doma.internal.apt.processor.AbstractGeneratingProcessor;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Embeddable"})
@SupportedOptions(value={"doma.version.validation", "doma.resources.dir", "doma.lombok.Value", "doma.lombok.AllArgsConstructor", "doma.test", "doma.debug", "doma.config.path", "doma.metamodel.enabled", "doma.metamodel.prefix", "doma.metamodel.suffix"})
public class EmbeddableProcessor
extends AbstractGeneratingProcessor<EmbeddableMeta> {
    public EmbeddableProcessor() {
        super(Embeddable.class);
    }

    @Override
    protected TypeElementMetaFactory<EmbeddableMeta> createTypeElementMetaFactory() {
        return new EmbeddableMetaFactory(this.ctx);
    }

    @Override
    protected ClassName createClassName(TypeElement typeElement, EmbeddableMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newEmbeddableTypeClassName((CharSequence)binaryName);
    }

    @Override
    protected Generator createGenerator(ClassName className, Printer printer, EmbeddableMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new EmbeddableTypeGenerator(this.ctx, className, printer, meta);
    }
}

