/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.util.AssertionUtil;

public class DomainCtType
extends AbstractCtType {
    private final BasicCtType basicCtType;
    private final List<CtType> typeArgCtTypes;
    private final ClassName typeClassName;

    DomainCtType(Context ctx, TypeMirror type, BasicCtType basicCtType, List<CtType> typeArgCtTypes, ClassName typeClassName) {
        super(ctx, type);
        AssertionUtil.assertNotNull((Object)basicCtType, typeArgCtTypes, (Object)typeClassName);
        this.basicCtType = basicCtType;
        this.typeArgCtTypes = typeArgCtTypes;
        this.typeClassName = typeClassName;
    }

    public BasicCtType getBasicCtType() {
        return this.basicCtType;
    }

    public boolean isRaw() {
        return this.typeArgCtTypes.stream().anyMatch(CtType::isNone);
    }

    public boolean hasWildcard() {
        return this.typeArgCtTypes.stream().anyMatch(CtType::isWildcard);
    }

    public boolean hasTypevar() {
        return this.typeArgCtTypes.stream().anyMatch(CtType::isTypevar);
    }

    public Code getTypeCode() {
        return new Code(p -> {
            if (this.typeArgCtTypes.isEmpty()) {
                p.print("%1$s.getSingletonInternal()", this.typeClassName);
            } else {
                List typeArgs = this.typeArgCtTypes.stream().map(CtType::getType).collect(Collectors.toList());
                p.print("%1$s.<%2$s>getSingletonInternal()", this.typeClassName, typeArgs);
            }
        });
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitDomainCtType(this, p);
    }
}

