/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;

public abstract class BatchModifyAnnot
extends AbstractAnnot {
    public static final String SQL_FILE = "sqlFile";
    public static final String QUERY_TIMEOUT = "queryTimeout";
    public static final String BATCH_SIZE = "batchSize";
    public static final String IGNORE_VERSION = "ignoreVersion";
    public static final String SUPPRESS_OPTIMISTIC_LOCK_EXCEPTION = "suppressOptimisticLockException";
    public static final String SQL_LOG = "sqlLog";
    public static final String INCLUDE = "include";
    public static final String EXCLUDE = "exclude";
    public static final String IGNORE_GENERATED_KEYS = "ignoreGeneratedKeys";
    private final AnnotationValue sqlFile;
    private final AnnotationValue queryTimeout;
    private final AnnotationValue batchSize;
    private final AnnotationValue ignoreVersion;
    private final AnnotationValue suppressOptimisticLockException;
    private final AnnotationValue include;
    private final AnnotationValue exclude;
    private final AnnotationValue sqlLog;
    private final AnnotationValue ignoreGeneratedKeys;

    BatchModifyAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.sqlFile = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SQL_FILE);
        this.queryTimeout = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)QUERY_TIMEOUT);
        this.batchSize = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)BATCH_SIZE);
        this.sqlLog = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SQL_LOG);
        this.ignoreVersion = values.get(IGNORE_VERSION);
        this.suppressOptimisticLockException = values.get(SUPPRESS_OPTIMISTIC_LOCK_EXCEPTION);
        this.include = values.get(INCLUDE);
        this.exclude = values.get(EXCLUDE);
        this.ignoreGeneratedKeys = values.get(IGNORE_GENERATED_KEYS);
    }

    public AnnotationValue getSqlFile() {
        return this.sqlFile;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getBatchSize() {
        return this.batchSize;
    }

    public AnnotationValue getIgnoreVersion() {
        return this.ignoreVersion;
    }

    public AnnotationValue getSuppressOptimisticLockException() {
        return this.suppressOptimisticLockException;
    }

    public AnnotationValue getInclude() {
        return this.include;
    }

    public AnnotationValue getExclude() {
        return this.exclude;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public AnnotationValue getIgnoreGeneratedKeys() {
        return this.ignoreGeneratedKeys;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException(QUERY_TIMEOUT);
        }
        return value;
    }

    public int getBatchSizeValue() {
        Integer value = AnnotationValueUtil.toInteger(this.batchSize);
        if (value == null) {
            throw new AptIllegalStateException(BATCH_SIZE);
        }
        return value;
    }

    public Boolean getIgnoreVersionValue() {
        return AnnotationValueUtil.toBoolean(this.ignoreVersion);
    }

    public Boolean getSuppressOptimisticLockExceptionValue() {
        return AnnotationValueUtil.toBoolean(this.suppressOptimisticLockException);
    }

    public List<String> getIncludeValue() {
        return AnnotationValueUtil.toStringList(this.include);
    }

    public List<String> getExcludeValue() {
        return AnnotationValueUtil.toStringList(this.exclude);
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException(SQL_LOG);
        }
        return SqlLogType.valueOf((String)enumConstant.getSimpleName().toString());
    }

    public boolean getSqlFileValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.sqlFile);
        if (value == null) {
            throw new AptIllegalStateException(SQL_FILE);
        }
        return value;
    }

    public Boolean getIgnoreGeneratedKeysValues() {
        return AnnotationValueUtil.toBoolean(this.ignoreGeneratedKeys);
    }
}

