/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class MetamodelAnnot
extends AbstractAnnot {
    private static final String PREFIX = "prefix";
    private static final String SUFFIX = "suffix";
    private static final String SCOPES = "scopes";
    private final AnnotationValue prefix;
    private final AnnotationValue suffix;
    private final AnnotationValue scopes;

    MetamodelAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.prefix = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)PREFIX);
        this.suffix = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SUFFIX);
        this.scopes = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SCOPES);
    }

    public AnnotationValue getPrefix() {
        return this.prefix;
    }

    public AnnotationValue getSuffix() {
        return this.suffix;
    }

    public AnnotationValue getScopes() {
        return this.scopes;
    }

    public String getPrefixValue() {
        String value = AnnotationValueUtil.toString(this.prefix);
        if (value == null) {
            throw new AptIllegalStateException(PREFIX);
        }
        return value;
    }

    public String getSuffixValue() {
        String value = AnnotationValueUtil.toString(this.suffix);
        if (value == null) {
            throw new AptIllegalStateException(SUFFIX);
        }
        return value;
    }

    public List<TypeMirror> getScopesValue() {
        List<TypeMirror> value = AnnotationValueUtil.toTypeList(this.scopes);
        if (value == null) {
            throw new AptIllegalStateException(SCOPES);
        }
        return value;
    }
}

