/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;

public class ProcedureAnnot
extends AbstractAnnot {
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String NAME = "name";
    private static final String QUOTE = "quote";
    private static final String QUERY_TIMEOUT = "queryTimeout";
    private static final String MAP_KEY_NAMING = "mapKeyNaming";
    private static final String SQL_LOG = "sqlLog";
    private final AnnotationValue catalog;
    private final AnnotationValue schema;
    private final AnnotationValue name;
    private final AnnotationValue quote;
    private final AnnotationValue queryTimeout;
    private final AnnotationValue mapKeyNaming;
    private final AnnotationValue sqlLog;
    private final String defaultName;

    ProcedureAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values, String defaultName) {
        super(annotationMirror);
        this.catalog = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)CATALOG);
        this.schema = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SCHEMA);
        this.name = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)NAME);
        this.quote = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)QUOTE);
        this.queryTimeout = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)QUERY_TIMEOUT);
        this.mapKeyNaming = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)MAP_KEY_NAMING);
        this.sqlLog = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SQL_LOG);
        this.defaultName = defaultName;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getMapKeyNaming() {
        return this.mapKeyNaming;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public String getCatalogValue() {
        String value = AnnotationValueUtil.toString(this.catalog);
        if (value == null) {
            throw new AptIllegalStateException(CATALOG);
        }
        return value;
    }

    public String getSchemaValue() {
        String value = AnnotationValueUtil.toString(this.schema);
        if (value == null) {
            throw new AptIllegalStateException(SCHEMA);
        }
        return value;
    }

    public String getNameValue() {
        String value = AnnotationValueUtil.toString(this.name);
        if (value == null || value.isEmpty()) {
            return this.defaultName;
        }
        return value;
    }

    public boolean getQuoteValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.quote);
        if (value == null) {
            throw new AptIllegalStateException(QUOTE);
        }
        return value;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException(QUERY_TIMEOUT);
        }
        return value;
    }

    public MapKeyNamingType getMapKeyNamingValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.mapKeyNaming);
        if (enumConstant == null) {
            throw new AptIllegalStateException(MAP_KEY_NAMING);
        }
        return MapKeyNamingType.valueOf((String)enumConstant.getSimpleName().toString());
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException(SQL_LOG);
        }
        return SqlLogType.valueOf((String)enumConstant.getSimpleName().toString());
    }
}

