/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.decl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.decl.ConstructorDeclaration;
import org.seasar.doma.internal.apt.decl.FieldDeclaration;
import org.seasar.doma.internal.apt.decl.MethodDeclaration;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Zip;

public class Declarations {
    private final Context ctx;

    public Declarations(Context ctx) {
        AssertionUtil.assertNotNull((Object)ctx);
        this.ctx = ctx;
    }

    public TypeDeclaration newUnknownTypeDeclaration() {
        NoType type = this.ctx.getMoreTypes().getNoType(TypeKind.NONE);
        return this.newTypeDeclaration(type, null);
    }

    public TypeDeclaration newPrimitiveBooleanTypeDeclaration() {
        TypeMirror type = this.ctx.getMoreTypes().getTypeMirror(Boolean.TYPE);
        return this.newTypeDeclaration(type, null);
    }

    public TypeDeclaration newTypeDeclaration(Class<?> clazz) {
        AssertionUtil.assertNotNull(clazz);
        TypeMirror type = this.ctx.getMoreTypes().getTypeMirror(clazz);
        return this.newTypeDeclaration(type);
    }

    public TypeDeclaration newTypeDeclaration(TypeMirror type) {
        AssertionUtil.assertNotNull((Object)type);
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        return this.newTypeDeclaration(type, typeElement);
    }

    public TypeDeclaration newTypeDeclaration(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newTypeDeclaration(typeElement.asType(), typeElement);
    }

    private TypeDeclaration newTypeDeclaration(TypeMirror type, TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)type);
        CtType ctType = this.ctx.getCtTypes().newCtType(type);
        LinkedHashMap<Name, List<TypeParameterDeclaration>> map = new LinkedHashMap<Name, List<TypeParameterDeclaration>>();
        this.gatherTypeParameterDeclarations(type, map);
        return new TypeDeclaration(this.ctx, type, ctType, typeElement, map);
    }

    private void gatherTypeParameterDeclarations(TypeMirror type, Map<Name, List<TypeParameterDeclaration>> typeParameterDeclarationsMap) {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement == null) {
            return;
        }
        Name canonicalName = typeElement.getQualifiedName();
        typeParameterDeclarationsMap.put(canonicalName, this.newTypeParameterDeclaration(typeElement, type));
        for (TypeMirror typeMirror : this.ctx.getMoreTypes().directSupertypes(type)) {
            Name superCanonicalName;
            TypeElement superElement = this.ctx.getMoreTypes().toTypeElement(typeMirror);
            if (superElement == null || typeParameterDeclarationsMap.containsKey(superCanonicalName = superElement.getQualifiedName())) continue;
            typeParameterDeclarationsMap.put(superCanonicalName, this.newTypeParameterDeclaration(superElement, typeMirror));
            this.gatherTypeParameterDeclarations(typeMirror, typeParameterDeclarationsMap);
        }
    }

    private List<TypeParameterDeclaration> newTypeParameterDeclaration(TypeElement typeElement, TypeMirror type) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)type);
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        return Zip.stream(typeElement.getTypeParameters(), declaredType.getTypeArguments()).map(p -> new TypeParameterDeclaration(((TypeParameterElement)p.fst).asType(), (TypeMirror)p.snd)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    FieldDeclaration newFieldDeclaration(VariableElement fieldElement, List<TypeParameterDeclaration> typeParameterDeclarations) {
        AssertionUtil.assertNotNull((Object)fieldElement, typeParameterDeclarations);
        AssertionUtil.assertTrue((fieldElement.getKind() == ElementKind.FIELD || fieldElement.getKind() == ElementKind.ENUM_CONSTANT ? 1 : 0) != 0, (Object[])new Object[]{fieldElement.getKind().toString()});
        TypeMirror fieldType = this.resolveTypeParameter(fieldElement.asType(), typeParameterDeclarations);
        TypeDeclaration typeDeclaration = this.newTypeDeclaration(fieldType);
        return new FieldDeclaration(fieldElement, typeDeclaration);
    }

    ConstructorDeclaration newConstructorDeclaration(ExecutableElement constructorElement) {
        AssertionUtil.assertNotNull((Object)constructorElement);
        AssertionUtil.assertTrue((constructorElement.getKind() == ElementKind.CONSTRUCTOR ? 1 : 0) != 0, (Object[])new Object[0]);
        return new ConstructorDeclaration(constructorElement);
    }

    MethodDeclaration newMethodDeclaration(ExecutableElement methodElement, List<TypeParameterDeclaration> typeParameterDeclarations) {
        AssertionUtil.assertNotNull((Object)methodElement, typeParameterDeclarations);
        AssertionUtil.assertTrue((methodElement.getKind() == ElementKind.METHOD ? 1 : 0) != 0, (Object[])new Object[0]);
        TypeMirror returnTypeMirror = this.resolveTypeParameter(methodElement.getReturnType(), typeParameterDeclarations);
        TypeDeclaration returnTypeDeclaration = this.newTypeDeclaration(returnTypeMirror);
        return new MethodDeclaration(methodElement, returnTypeDeclaration);
    }

    public TypeParameterDeclaration newTypeParameterDeclarationUsingTypeParams(TypeMirror formalType, List<TypeParameterDeclaration> typeParameterDeclarations) {
        TypeMirror actualType = this.resolveTypeParameter(formalType, typeParameterDeclarations);
        return new TypeParameterDeclaration(formalType, actualType);
    }

    private TypeMirror resolveTypeParameter(TypeMirror formalType, List<TypeParameterDeclaration> typeParameterDeclarations) {
        for (TypeParameterDeclaration typeParameterDecl : typeParameterDeclarations) {
            List optTypeArgs;
            if (formalType.equals(typeParameterDecl.getFormalType())) {
                return typeParameterDecl.getActualType();
            }
            DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(formalType);
            if (declaredType == null || declaredType.getTypeArguments().isEmpty() || !(optTypeArgs = declaredType.getTypeArguments().stream().map(arg -> typeParameterDeclarations.stream().filter(declaration -> arg.equals(declaration.getFormalType())).map(TypeParameterDeclaration::getActualType).findFirst()).collect(Collectors.toList())).stream().allMatch(Optional::isPresent)) continue;
            TypeMirror[] typeArgs = (TypeMirror[])optTypeArgs.stream().map(Optional::get).toArray(TypeMirror[]::new);
            TypeElement typeElement = this.ctx.getMoreElements().toTypeElement(declaredType.asElement());
            if (typeElement == null) continue;
            return this.ctx.getMoreTypes().getDeclaredType(typeElement, typeArgs);
        }
        return formalType;
    }
}

