/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.def.TypeParametersDef;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.query.Query;

public abstract class AbstractQueryMeta
implements QueryMeta {
    private final String name;
    private final ExecutableElement methodElement;
    private final TypeElement daoElement;
    private final List<TypeMirror> thrownTypes = new ArrayList<TypeMirror>();
    QueryKind queryKind;
    private final LinkedHashMap<String, TypeMirror> bindableParameterTypeMap = new LinkedHashMap();
    private QueryReturnMeta returnMeta;
    private final List<QueryParameterMeta> parameterMetas = new ArrayList<QueryParameterMeta>();
    private final List<String> fileNames = new ArrayList<String>();
    private TypeParametersDef typeParametersDef;

    AbstractQueryMeta(TypeElement daoElement, ExecutableElement methodElement) {
        AssertionUtil.assertNotNull((Object)daoElement, (Object)methodElement);
        this.daoElement = daoElement;
        this.methodElement = methodElement;
        this.name = methodElement.getSimpleName().toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ExecutableElement getMethodElement() {
        return this.methodElement;
    }

    @Override
    public TypeElement getDaoElement() {
        return this.daoElement;
    }

    @Override
    public List<String> getTypeParameterNames() {
        return this.typeParametersDef.getTypeParameters();
    }

    public void setTypeParametersDef(TypeParametersDef typeParametersDef) {
        this.typeParametersDef = typeParametersDef;
    }

    @Override
    public List<TypeMirror> getThrownTypes() {
        return this.thrownTypes;
    }

    public void addThrownType(TypeMirror thrownType) {
        this.thrownTypes.add(thrownType);
    }

    public Class<? extends Query> getQueryClass() {
        if (this.queryKind == null) {
            return null;
        }
        return this.queryKind.getQueryClass();
    }

    public Class<?> getCommandClass() {
        if (this.queryKind == null) {
            return null;
        }
        return this.queryKind.getCommandClass();
    }

    @Override
    public QueryKind getQueryKind() {
        return this.queryKind;
    }

    public void setQueryKind(QueryKind queryKind) {
        this.queryKind = queryKind;
    }

    public LinkedHashMap<String, TypeMirror> getBindableParameterTypeMap() {
        return this.bindableParameterTypeMap;
    }

    public void addBindableParameterCtType(String parameterName, CtType bindableParameterCtType) {
        bindableParameterCtType.accept(new BindableParameterCtTypeVisitor(parameterName), null);
    }

    @Override
    public QueryReturnMeta getReturnMeta() {
        return this.returnMeta;
    }

    public void setReturnMeta(QueryReturnMeta returnMeta) {
        this.returnMeta = returnMeta;
    }

    @Override
    public List<QueryParameterMeta> getParameterMetas() {
        return this.parameterMetas;
    }

    public void addParameterMeta(QueryParameterMeta queryParameterMeta) {
        this.parameterMetas.add(queryParameterMeta);
    }

    @Override
    public List<String> getFileNames() {
        return this.fileNames;
    }

    public void addFileName(String fileName) {
        this.fileNames.add(fileName);
    }

    @Override
    public boolean isVarArgs() {
        return this.methodElement.isVarArgs();
    }

    class BindableParameterCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final String parameterName;

        BindableParameterCtTypeVisitor(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            AbstractQueryMeta.this.bindableParameterTypeMap.put(this.parameterName, ctType.getType());
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }
    }
}

