/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public abstract class ModifyAnnot
extends AbstractAnnot {
    private static final String SQL_FILE = "sqlFile";
    private static final String QUERY_TIMEOUT = "queryTimeout";
    private static final String IGNORE_VERSION = "ignoreVersion";
    private static final String EXCLUDE_NULL = "excludeNull";
    private static final String SUPPRESS_OPTIMISTIC_LOCK_EXCEPTION = "suppressOptimisticLockException";
    private static final String INCLUDE_UNCHANGED = "includeUnchanged";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String SQL_LOG = "sqlLog";
    private static final String DUPLICATE_KEY_TYPE = "duplicateKeyType";
    private final AnnotationValue sqlFile;
    private final AnnotationValue queryTimeout;
    private final AnnotationValue ignoreVersion;
    private final AnnotationValue excludeNull;
    private final AnnotationValue suppressOptimisticLockException;
    private final AnnotationValue includeUnchanged;
    private final AnnotationValue include;
    private final AnnotationValue exclude;
    private final AnnotationValue sqlLog;
    private final AnnotationValue duplicateKeyType;

    ModifyAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.sqlFile = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SQL_FILE);
        this.queryTimeout = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)QUERY_TIMEOUT);
        this.sqlLog = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SQL_LOG);
        this.ignoreVersion = values.get(IGNORE_VERSION);
        this.excludeNull = values.get(EXCLUDE_NULL);
        this.suppressOptimisticLockException = values.get(SUPPRESS_OPTIMISTIC_LOCK_EXCEPTION);
        this.includeUnchanged = values.get(INCLUDE_UNCHANGED);
        this.include = values.get(INCLUDE);
        this.exclude = values.get(EXCLUDE);
        this.duplicateKeyType = values.get(DUPLICATE_KEY_TYPE);
    }

    public AnnotationValue getSqlFile() {
        return this.sqlFile;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getIgnoreVersion() {
        return this.ignoreVersion;
    }

    public AnnotationValue getExcludeNull() {
        return this.excludeNull;
    }

    public AnnotationValue getSuppressOptimisticLockException() {
        return this.suppressOptimisticLockException;
    }

    public AnnotationValue getIncludeUnchanged() {
        return this.includeUnchanged;
    }

    public AnnotationValue getInclude() {
        return this.include;
    }

    public AnnotationValue getExclude() {
        return this.exclude;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public DuplicateKeyType getDuplicateKeyValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.duplicateKeyType);
        if (enumConstant == null) {
            throw new AptIllegalStateException(DUPLICATE_KEY_TYPE);
        }
        return DuplicateKeyType.valueOf((String)enumConstant.getSimpleName().toString());
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException(QUERY_TIMEOUT);
        }
        return value;
    }

    public Boolean getIgnoreVersionValue() {
        return AnnotationValueUtil.toBoolean(this.ignoreVersion);
    }

    public Boolean getExcludeNullValue() {
        return AnnotationValueUtil.toBoolean(this.excludeNull);
    }

    public Boolean getSuppressOptimisticLockExceptionValue() {
        return AnnotationValueUtil.toBoolean(this.suppressOptimisticLockException);
    }

    public Boolean getIncludeUnchangedValue() {
        return AnnotationValueUtil.toBoolean(this.includeUnchanged);
    }

    public List<String> getIncludeValue() {
        return AnnotationValueUtil.toStringList(this.include);
    }

    public List<String> getExcludeValue() {
        return AnnotationValueUtil.toStringList(this.exclude);
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException(SQL_LOG);
        }
        return SqlLogType.valueOf((String)enumConstant.getSimpleName().toString());
    }

    public boolean getSqlFileValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.sqlFile);
        if (value == null) {
            throw new AptIllegalStateException(SQL_FILE);
        }
        return value;
    }
}

