/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.util.AssertionUtil;

public class EntityCtType
extends AbstractCtType {
    private final boolean immutable;
    private final ClassName typeClassName;

    EntityCtType(Context ctx, TypeMirror type, boolean immutable, ClassName typeClassName) {
        super(ctx, type);
        AssertionUtil.assertNotNull((Object)typeClassName);
        this.immutable = immutable;
        this.typeClassName = typeClassName;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isAbstract() {
        return this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public Code getTypeCode() {
        return new Code(p -> p.print("%1$s.getSingletonInternal()", this.typeClassName));
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitEntityCtType(this, p);
    }
}

