/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Scope;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.processor.AbstractProcessor;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

@SupportedAnnotationTypes(value={"org.seasar.doma.Scope"})
@SupportedOptions(value={"doma.resources.dir", "doma.test", "doma.debug", "doma.config.path"})
public class ScopeProcessor
extends AbstractProcessor {
    public ScopeProcessor() {
        super(Scope.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (ExecutableElement element : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                this.handleExecutableElement(element, this::validate);
            }
        }
        return true;
    }

    protected void validate(ExecutableElement method) {
        if (method.getParameters().size() < 1) {
            throw new AptException((MessageResource)Message.DOMA4457, method, new Object[0]);
        }
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC)) {
            throw new AptException((MessageResource)Message.DOMA4458, method, new Object[0]);
        }
        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4459, method, new Object[0]);
        }
    }
}

