/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import javax.annotation.processing.ProcessingEnvironment;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.MoreElements;
import org.seasar.doma.internal.apt.MoreTypes;
import org.seasar.doma.internal.apt.Names;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.Reporter;
import org.seasar.doma.internal.apt.Resources;
import org.seasar.doma.internal.apt.annot.Annotations;
import org.seasar.doma.internal.apt.cttype.CtTypes;
import org.seasar.doma.internal.apt.decl.Declarations;

public class Context {
    private final ProcessingEnvironment env;
    private boolean initialized;
    private MoreElements moreElements;
    private MoreTypes moreTypes;
    private Options options;
    private Reporter reporter;
    private Resources resources;
    private Annotations annotations;
    private Declarations declarations;
    private CtTypes ctTypes;
    private Names names;

    public Context(ProcessingEnvironment env) {
        this.env = env;
    }

    public void init() {
        if (this.initialized) {
            throw new AptIllegalStateException("already initialized");
        }
        this.moreElements = new MoreElements(this, this.env);
        this.moreTypes = new MoreTypes(this, this.env);
        this.options = new Options(this, this.env);
        this.reporter = new Reporter(this.env);
        this.resources = new Resources(this, this.env);
        this.annotations = new Annotations(this);
        this.declarations = new Declarations(this);
        this.ctTypes = new CtTypes(this);
        this.names = new Names(this);
        this.initialized = true;
    }

    public MoreElements getMoreElements() {
        this.assertInitialized();
        return this.moreElements;
    }

    public MoreTypes getMoreTypes() {
        this.assertInitialized();
        return this.moreTypes;
    }

    public Options getOptions() {
        this.assertInitialized();
        return this.options;
    }

    public Reporter getReporter() {
        this.assertInitialized();
        return this.reporter;
    }

    public Resources getResources() {
        this.assertInitialized();
        return this.resources;
    }

    public Annotations getAnnotations() {
        this.assertInitialized();
        return this.annotations;
    }

    public Declarations getDeclarations() {
        this.assertInitialized();
        return this.declarations;
    }

    public CtTypes getCtTypes() {
        this.assertInitialized();
        return this.ctTypes;
    }

    public Names getNames() {
        this.assertInitialized();
        return this.names;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new AptIllegalStateException("not yet initialized");
        }
    }
}

