/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import org.seasar.doma.ParameterName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.def.TypeParametersDef;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.internal.util.Zip;

public class MoreElements
implements Elements {
    private final Context ctx;
    private final Elements elementUtils;
    private final Map<String, TypeElement> typeElementCache = new HashMap<String, TypeElement>(64);

    public MoreElements(Context ctx, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)env);
        this.ctx = ctx;
        this.elementUtils = env.getElementUtils();
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return this.elementUtils.getPackageElement(name);
    }

    @Override
    public TypeElement getTypeElement(CharSequence canonicalName) {
        AssertionUtil.assertNotNull((Object)canonicalName);
        return this.getTypeElementInternal(canonicalName.toString());
    }

    public TypeElement getTypeElement(Class<?> clazz) {
        AssertionUtil.assertNotNull(clazz);
        return this.getTypeElementInternal(clazz.getCanonicalName());
    }

    private TypeElement getTypeElementInternal(String canonicalName) {
        return this.typeElementCache.computeIfAbsent(canonicalName, this.elementUtils::getTypeElement);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.elementUtils.getElementValuesWithDefaults(a);
    }

    @Override
    public String getDocComment(Element e) {
        return this.elementUtils.getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.elementUtils.isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.elementUtils.getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.elementUtils.getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.elementUtils.getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.elementUtils.getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.elementUtils.hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.elementUtils.overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.elementUtils.getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.elementUtils.printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.elementUtils.getName(cs);
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        return this.elementUtils.isFunctionalInterface(type);
    }

    public String getParameterName(VariableElement variableElement) {
        AssertionUtil.assertNotNull((Object)variableElement);
        ParameterName parameterName = variableElement.getAnnotation(ParameterName.class);
        if (parameterName != null && !parameterName.value().isEmpty()) {
            return parameterName.value();
        }
        return variableElement.getSimpleName().toString();
    }

    public TypeElement toTypeElement(Element element) {
        AssertionUtil.assertNotNull((Object)element);
        return element.accept(new SimpleElementVisitor8<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    public TypeParameterElement toTypeParameterElement(Element element) {
        AssertionUtil.assertNotNull((Object)element);
        return element.accept(new SimpleElementVisitor8<TypeParameterElement, Void>(){

            @Override
            public TypeParameterElement visitTypeParameter(TypeParameterElement e, Void aVoid) {
                return e;
            }
        }, null);
    }

    public ExecutableType toExecutableType(Element element) {
        AssertionUtil.assertNotNull((Object)element);
        return element.accept(new SimpleElementVisitor8<ExecutableType, Void>(){

            public ExecutableType visitExecutableType(ExecutableType e, Void p) {
                return e;
            }
        }, null);
    }

    public TypeElement getTypeElementFromBinaryName(String binaryName) {
        AssertionUtil.assertNotNull((Object)binaryName);
        String[] parts = binaryName.split("\\$");
        if (parts.length > 1) {
            TypeElement topElement = this.getTypeElementFromBinaryName(parts[0]);
            if (topElement == null) {
                return null;
            }
            return this.getEnclosedTypeElement(topElement, Arrays.asList(parts).subList(1, parts.length));
        }
        try {
            return this.getTypeElement(binaryName);
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    private TypeElement getEnclosedTypeElement(TypeElement typeElement, List<String> enclosedNames) {
        TypeElement enclosing = typeElement;
        block0: for (String enclosedName : enclosedNames) {
            for (TypeElement enclosed : ElementFilter.typesIn(enclosing.getEnclosedElements())) {
                if (!enclosed.getSimpleName().contentEquals(enclosedName)) continue;
                enclosing = enclosed;
                continue block0;
            }
        }
        return typeElement != enclosing ? enclosing : null;
    }

    public AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        AssertionUtil.assertNotNull((Object)element, annotationClass);
        return this.getAnnotationMirrorInternal(element, type -> this.ctx.getMoreTypes().isSameTypeWithErasure((TypeMirror)type, annotationClass));
    }

    public AnnotationMirror getAnnotationMirror(Element element, String annotationClassName) {
        AssertionUtil.assertNotNull((Object)element, (Object)annotationClassName);
        return this.getAnnotationMirrorInternal(element, type -> {
            TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement((TypeMirror)type);
            if (typeElement == null) {
                return false;
            }
            return typeElement.getQualifiedName().contentEquals(annotationClassName);
        });
    }

    private AnnotationMirror getAnnotationMirrorInternal(Element element, Predicate<DeclaredType> predicate) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!predicate.test(annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    public ExecutableElement getNoArgConstructor(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        for (ExecutableElement constructor : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (!constructor.getParameters().isEmpty()) continue;
            return constructor;
        }
        return null;
    }

    public Map<String, AnnotationValue> getValuesWithoutDefaults(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull((Object)annotationMirror);
        HashMap<String, AnnotationValue> map = new HashMap<String, AnnotationValue>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            String key = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, AnnotationValue> getValuesWithDefaults(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull((Object)annotationMirror);
        HashMap<String, AnnotationValue> map = new HashMap<String, AnnotationValue>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : this.getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String key = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public TypeParametersDef getTypeParametersDef(Parameterizable element) {
        AssertionUtil.assertNotNull((Object)element);
        List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
        List<String> typeParameterNames = this.getTypeParameterNames(typeParameters);
        Iterator<String> values = typeParameterNames.iterator();
        Iterator<? extends TypeParameterElement> keys = typeParameters.iterator();
        LinkedHashMap<TypeParameterElement, String> map = new LinkedHashMap<TypeParameterElement, String>();
        while (keys.hasNext() && values.hasNext()) {
            map.put(keys.next(), values.next());
        }
        return new TypeParametersDef(map);
    }

    List<String> getTypeParameterNames(List<? extends TypeParameterElement> typeParameterElements) {
        AssertionUtil.assertNotNull(typeParameterElements);
        List<TypeMirror> typeMirrors = typeParameterElements.stream().map(Element::asType).collect(Collectors.toList());
        return this.ctx.getMoreTypes().getTypeParameterNames(typeMirrors);
    }

    public boolean isVirtualDefaultMethod(TypeElement typeElement, ExecutableElement methodElement) {
        return ElementFilter.typesIn(typeElement.getEnclosedElements()).stream().filter(t -> t.getSimpleName().contentEquals("DefaultImpls")).anyMatch(t -> ElementFilter.methodsIn(t.getEnclosedElements()).stream().filter(m -> {
            EnumSet<Modifier> set = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC);
            return m.getModifiers().containsAll(set);
        }).filter(m -> {
            Name name1 = m.getSimpleName();
            Name name2 = methodElement.getSimpleName();
            return name1.contentEquals(name2);
        }).filter(m -> {
            TypeMirror type1 = m.getReturnType();
            TypeMirror type2 = methodElement.getReturnType();
            return this.ctx.getMoreTypes().isSameType(type1, type2);
        }).filter(m -> {
            int size2;
            int size1 = m.getParameters().size();
            return size1 == (size2 = methodElement.getParameters().size() + 1);
        }).filter(m -> {
            TypeMirror type1 = m.getParameters().iterator().next().asType();
            TypeMirror type2 = typeElement.asType();
            return this.ctx.getMoreTypes().isSameTypeWithErasure(type1, type2);
        }).anyMatch(m -> {
            Stream parameters1 = m.getParameters().stream().skip(1L);
            Stream parameters2 = methodElement.getParameters().stream();
            return Zip.stream(parameters1, parameters2).map(pair -> new Pair((Object)((VariableElement)pair.fst).asType(), (Object)((VariableElement)pair.snd).asType())).allMatch(p -> this.ctx.getMoreTypes().isSameType((TypeMirror)p.fst, (TypeMirror)p.snd));
        }));
    }
}

