/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class SqlAnnot
extends AbstractAnnot {
    private static final String VALUE = "value";
    private final AnnotationValue value;

    SqlAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.value = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)VALUE);
    }

    public AnnotationValue getValue() {
        return this.value;
    }

    public String getValueValue() {
        String sql = AnnotationValueUtil.toString(this.value);
        if (sql == null) {
            throw new AptIllegalStateException(VALUE);
        }
        return sql;
    }
}

