/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import org.seasar.doma.DomainTypeImplementation;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.domain.DomainMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.BoxedPrimitiveUtil;
import org.seasar.doma.jdbc.domain.AbstractDomainType;

public class DomainTypeGenerator
extends AbstractGenerator {
    private final DomainMeta domainMeta;

    public DomainTypeGenerator(Context ctx, ClassName className, Printer printer, DomainMeta domainMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)domainMeta);
        this.domainMeta = domainMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        if (this.domainMeta.isParameterized()) {
            this.iprint("/**%n", new Object[0]);
            for (String typeVariable : this.domainMeta.getTypeVariables()) {
                this.iprint(" * @param <%1$s> %1$s%n", typeVariable);
            }
            this.iprint(" */%n", new Object[0]);
        } else {
            this.iprint("/** */%n", new Object[0]);
        }
        this.printGenerated();
        this.printDomainTypeImplementation();
        if (this.domainMeta.isParameterized()) {
            this.iprint("public final class %1$s<%5$s> extends %2$s<%3$s, %4$s> {%n", this.simpleName, AbstractDomainType.class, this.ctx.getMoreTypes().boxIfPrimitive(this.domainMeta.getValueType()), this.domainMeta.getType(), this.domainMeta.getTypeParameters());
        } else {
            this.iprint("public final class %1$s extends %2$s<%3$s, %4$s> {%n", this.simpleName, AbstractDomainType.class, this.ctx.getMoreTypes().boxIfPrimitive(this.domainMeta.getValueType()), this.domainMeta.getType());
        }
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printDomainTypeImplementation() {
        this.iprint("@%1$s%n", DomainTypeImplementation.class);
    }

    private void printFields() {
        if (this.domainMeta.isParameterized()) {
            this.iprint("@SuppressWarnings(\"rawtypes\")%n", new Object[0]);
        }
        this.iprint("private static final %1$s singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    private void printConstructors() {
        this.iprint("private %1$s() {%n", this.simpleName);
        this.iprint("    super(%1$s);%n", this.domainMeta.getBasicCtType().getWrapperSupplierCode());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        this.printNewDomainMethod();
        this.printGetBasicValueMethod();
        this.printGetBasicClassMethod();
        this.printGetDomainClassMethod();
        this.printGetSingletonInternalMethod();
    }

    private void printNewDomainMethod() {
        boolean primitive = this.domainMeta.getBasicCtType().isPrimitive();
        this.iprint("@Override%n", new Object[0]);
        this.iprint("protected %1$s newDomain(%2$s value) {%n", this.domainMeta.getType(), this.ctx.getMoreTypes().boxIfPrimitive(this.domainMeta.getValueType()));
        if (!primitive && !this.domainMeta.getAcceptNull()) {
            this.iprint("    if (value == null) {%n", new Object[0]);
            this.iprint("        return null;%n", new Object[0]);
            this.iprint("    }%n", new Object[0]);
        }
        if (this.domainMeta.providesConstructor()) {
            if (primitive) {
                this.iprint("    return new %1$s(%2$s.unbox(value));%n", this.domainMeta.getType(), BoxedPrimitiveUtil.class);
            } else {
                this.iprint("    return new %1$s(value);%n", this.domainMeta.getType());
            }
        } else if (primitive) {
            this.iprint("    return %1$s.%2$s(%3$s.unbox(value));%n", this.domainMeta.getTypeElement(), this.domainMeta.getFactoryMethod(), BoxedPrimitiveUtil.class);
        } else {
            this.iprint("    return %1$s.%2$s(value);%n", this.domainMeta.getTypeElement(), this.domainMeta.getFactoryMethod());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetBasicValueMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("protected %1$s getBasicValue(%2$s domain) {%n", this.ctx.getMoreTypes().boxIfPrimitive(this.domainMeta.getValueType()), this.domainMeta.getType());
        this.iprint("    if (domain == null) {%n", new Object[0]);
        this.iprint("        return null;%n", new Object[0]);
        this.iprint("    }%n", new Object[0]);
        this.iprint("    return domain.%1$s();%n", this.domainMeta.getAccessorMethod());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetBasicClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<?> getBasicClass() {%n", new Object[0]);
        this.iprint("    return %1$s.class;%n", this.domainMeta.getValueType());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetDomainClassMethod() {
        if (this.domainMeta.isParameterized()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getDomainClass() {%n", this.domainMeta.getType());
        if (this.domainMeta.isParameterized()) {
            this.iprint("    Class<?> clazz = %1$s.class;%n", this.domainMeta.getTypeElement());
            this.iprint("    return (Class<%1$s>) clazz;%n", this.domainMeta.getType());
        } else {
            this.iprint("    return %1$s.class;%n", this.domainMeta.getTypeElement());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        if (this.domainMeta.isParameterized()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
            this.iprint("public static <%1$s> %2$s<%3$s> getSingletonInternal() {%n", this.domainMeta.getTypeParameters(), this.simpleName, this.domainMeta.getTypeVariables());
            this.iprint("    return (%1$s<%2$s>) singleton;%n", this.simpleName, this.domainMeta.getTypeVariables());
        } else {
            this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
            this.iprint("    return singleton;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }
}

