/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.MultiInsertAnnot;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoMultiInsertQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoMultiInsertQueryMetaFactory
extends AbstractQueryMetaFactory<AutoMultiInsertQueryMeta> {
    public AutoMultiInsertQueryMetaFactory(Context ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta() {
        AutoMultiInsertQueryMeta queryMeta = this.createAutoMultiInsertQueryMeta();
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        return queryMeta;
    }

    private AutoMultiInsertQueryMeta createAutoMultiInsertQueryMeta() {
        AutoMultiInsertQueryMeta queryMeta = new AutoMultiInsertQueryMeta(this.daoElement, this.methodElement);
        MultiInsertAnnot insertAnnot = this.ctx.getAnnotations().newMultiInsertAnnot(this.methodElement);
        if (insertAnnot != null) {
            queryMeta.setMultiInsertAnnot(insertAnnot);
            queryMeta.setQueryKind(QueryKind.AUTO_MULTI_INSERT);
            return queryMeta;
        }
        return null;
    }

    @Override
    protected void doReturnType(AutoMultiInsertQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        EntityCtType entityCtType = queryMeta.getEntityCtType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            if (!returnMeta.isMultiResult(entityCtType)) {
                throw new AptException((MessageResource)Message.DOMA4461, this.methodElement, new Object[0]);
            }
        } else if (!returnMeta.isPrimitiveInt()) {
            throw new AptException((MessageResource)Message.DOMA4001, this.methodElement, new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(AutoMultiInsertQueryMeta queryMeta) {
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.methodElement, new Object[0]);
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        IterableCtType iterableCtType = parameterMeta.getCtType().accept(new SimpleCtTypeVisitor<IterableCtType, Void, RuntimeException>(){

            @Override
            protected IterableCtType defaultAction(CtType ctType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4042, AutoMultiInsertQueryMetaFactory.this.methodElement, new Object[0]);
            }

            @Override
            public IterableCtType visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
                return ctType;
            }
        }, null);
        EntityCtType entityCtType = iterableCtType.getElementCtType().accept(new SimpleCtTypeVisitor<EntityCtType, Void, RuntimeException>(){

            @Override
            protected EntityCtType defaultAction(CtType ctType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4043, AutoMultiInsertQueryMetaFactory.this.methodElement, new Object[0]);
            }

            @Override
            public EntityCtType visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                return ctType;
            }
        }, null);
        queryMeta.setEntityCtType(entityCtType);
        queryMeta.setEntityParameterName(parameterMeta.getName());
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
        MultiInsertAnnot insertAnnot = queryMeta.getMultiInsertAnnot();
        this.validateEntityPropertyNames(entityCtType.getType(), insertAnnot.getAnnotationMirror(), insertAnnot.getInclude(), insertAnnot.getExclude(), insertAnnot.getDuplicateKeys());
    }
}

